/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.service;

import org.openvpms.archetype.component.dispatcher.Dispatcher;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.sms.internal.service.SMSQueryFactory;
import org.openvpms.sms.internal.service.SMSQueue;
import org.openvpms.sms.internal.service.SMSQueues;
import org.slf4j.Logger;

public abstract class SMSDispatcher
extends Dispatcher<Act, SMSDispatcher, SMSQueue> {
    private final ArchetypeService service;
    private final SMSQueryFactory queryFactory;

    public SMSDispatcher(String archetype, ArchetypeService service, PracticeService practiceService, Logger log) {
        super(practiceService, log);
        this.service = service;
        this.queryFactory = new SMSQueryFactory(archetype, service);
        this.init(new SMSQueues(this));
    }

    protected Act getNext() {
        TypedQuery<Act> query = this.queryFactory.create();
        return (Act)query.getFirstResult();
    }

    protected ArchetypeService getService() {
        return this.service;
    }
}

