/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.exception.DuplicateSMSException;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.internal.i18n.SMSMessages;
import org.openvpms.sms.internal.message.OutboundMessageImpl;
import org.openvpms.sms.internal.message.QueueStatus;
import org.openvpms.sms.internal.message.ReceivedMessageBuilderImpl;
import org.openvpms.sms.internal.message.ReplyBuilderImpl;
import org.openvpms.sms.internal.message.SMSMessageHelper;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.message.ReplyBuilder;
import org.openvpms.sms.message.StateBuilder;

public class StateBuilderImpl
implements StateBuilder {
    private final OutboundMessageImpl message;
    private final IMObjectBean bean;
    private final ArchetypeService service;
    private final DomainService domainService;
    private final List<Act> replies = new ArrayList<Act>();
    private String archetype;
    private String id;
    private OutboundMessage.Status status;
    private String statusMessage;
    private static final String DELIVERED_NODE = "endTime";
    private static final String STATUS_NODE = "status";
    private static final String STATUS_MESSAGE_NODE = "statusMessage";
    private static final String QUEUE_STATUS_NODE = "status2";

    StateBuilderImpl(OutboundMessageImpl message, IMObjectBean bean, ArchetypeService service, DomainService domainService) {
        this.message = message;
        this.bean = bean;
        this.service = service;
        this.domainService = domainService;
    }

    public StateBuilder providerId(String archetype, String id) {
        this.archetype = archetype;
        this.id = id;
        return this;
    }

    public StateBuilder status(OutboundMessage.Status status) {
        return this.status(status, null);
    }

    public StateBuilder status(OutboundMessage.Status status, String statusMessage) {
        this.status = status;
        this.statusMessage = statusMessage;
        return this;
    }

    public ReplyBuilder reply() {
        return new ReplyBuilderImpl(this, this.service, this.domainService);
    }

    public OutboundMessage build() {
        boolean changed = false;
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        if (this.archetype != null) {
            changed = this.setIdentity();
        }
        if (this.status != null) {
            changed |= this.setStatus();
            changed |= this.setStatusMessage();
        }
        if (changed |= this.addReplies(toSave)) {
            this.message.setUpdated();
            toSave.add(0, this.bean.getObject());
            this.service.save(toSave);
        }
        return this.message;
    }

    void addReply(Act reply) {
        this.replies.add(reply);
    }

    private boolean setIdentity() {
        boolean changed = false;
        if (!TypeHelper.isA((String)this.archetype, (String[])new String[]{"actIdentity.sms*"})) {
            throw new IllegalStateException("Invalid identity archetype: " + this.archetype);
        }
        if (SMSMessageHelper.isDuplicateOutboundId(this.archetype, this.id, this.bean.getObject().getId(), this.service)) {
            throw new DuplicateSMSException(SMSMessages.duplicateOutboundMessageId(this.id));
        }
        ActIdentity identity = this.message.getIdentity();
        if (identity == null) {
            identity = (ActIdentity)this.service.create(this.archetype, ActIdentity.class);
            this.bean.addValue("providerId", (IMObject)identity);
            changed = true;
        } else if (!identity.isA(this.archetype)) {
            throw new SMSException(SMSMessages.differentMessageIdentifierArchetype(identity.getArchetype(), this.archetype));
        }
        if (!Objects.equals(this.id, identity.getIdentity())) {
            identity.setIdentity(this.id);
            changed = true;
        }
        return changed;
    }

    private boolean setStatus() {
        boolean changed = false;
        OutboundMessage.Status current = this.message.getStatus();
        if (!current.canTransition(this.status)) {
            throw new IllegalStateException("Cannot transition from " + current + " to " + this.status);
        }
        if (this.status != current) {
            if (this.status == OutboundMessage.Status.SENT || this.status == OutboundMessage.Status.DELIVERED && this.bean.getDate(DELIVERED_NODE) == null) {
                this.bean.setValue(DELIVERED_NODE, (Object)new Date());
            }
            this.bean.setValue(STATUS_NODE, (Object)this.status.toString());
            if (this.message.getQueueStatus() != QueueStatus.COMPLETED) {
                this.bean.setValue(QUEUE_STATUS_NODE, (Object)QueueStatus.COMPLETED.toString());
            }
            changed = true;
        }
        return changed;
    }

    private boolean setStatusMessage() {
        boolean changed = false;
        if (!StringUtils.isEmpty((CharSequence)this.statusMessage)) {
            this.statusMessage = StringUtils.abbreviate((String)this.statusMessage, (int)this.bean.getMaxLength(STATUS_MESSAGE_NODE));
        }
        if (!Objects.equals(this.statusMessage, this.bean.getString(STATUS_MESSAGE_NODE))) {
            this.bean.setValue(STATUS_MESSAGE_NODE, (Object)this.statusMessage);
            changed = true;
        }
        return changed;
    }

    private boolean addReplies(List<IMObject> toSave) {
        boolean changed = false;
        if (!this.replies.isEmpty()) {
            HashSet<String> ids = new HashSet<String>();
            for (Act reply : this.replies) {
                IMObjectBean replyBean = this.service.getBean((IMObject)reply);
                String id = SMSMessageHelper.getProviderId(replyBean);
                if (id != null && !ids.add(id)) {
                    throw new DuplicateSMSException(SMSMessages.duplicateInboundMessageId(id));
                }
                ReceivedMessageBuilderImpl.copyMessageDetailsToReply(this.bean, replyBean);
                this.bean.addTarget("replies", (IMObject)reply, "sms");
            }
            toSave.addAll(this.replies);
            this.replies.clear();
            changed = true;
        }
        return changed;
    }
}

