/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import java.time.OffsetDateTime;
import java.util.HashSet;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.exception.DuplicateSMSException;
import org.openvpms.sms.internal.i18n.SMSMessages;
import org.openvpms.sms.internal.message.InboundMessageImpl;
import org.openvpms.sms.internal.message.MessageBuilderImpl;
import org.openvpms.sms.internal.message.SMSMessageHelper;
import org.openvpms.sms.message.InboundMessage;
import org.openvpms.sms.message.ReceivedMessageBuilder;

public class ReceivedMessageBuilderImpl<T extends ReceivedMessageBuilder<T>>
extends MessageBuilderImpl<T>
implements ReceivedMessageBuilder<T> {
    private final ArchetypeService service;
    private final DomainService domainService;
    private String archetype;
    private String id;
    private OffsetDateTime received;

    public ReceivedMessageBuilderImpl(ArchetypeService service, DomainService domainService) {
        this.service = service;
        this.domainService = domainService;
    }

    public T providerId(String archetype, String id) {
        this.archetype = archetype;
        this.id = id;
        return (T)((ReceivedMessageBuilder)this.getThis());
    }

    public T received(OffsetDateTime timestamp) {
        this.received = timestamp;
        return (T)((ReceivedMessageBuilder)this.getThis());
    }

    public InboundMessage build() {
        IMObjectBean bean = this.doBuild();
        return new InboundMessageImpl(bean, this.service, this.domainService);
    }

    protected IMObjectBean doBuild() {
        if (this.archetype != null && this.id != null) {
            if (!TypeHelper.isA((String)this.archetype, (String[])new String[]{"actIdentity.sms*"})) {
                throw new IllegalStateException("Invalid identity archetype: " + this.archetype);
            }
            if (this.isDuplicate()) {
                throw new DuplicateSMSException(SMSMessages.duplicateInboundMessageId(this.id));
            }
        }
        Act act = (Act)this.service.create("act.smsReply", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        this.build(act, bean);
        return bean;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected DomainService getDomainService() {
        return this.domainService;
    }

    protected void build(Act act, IMObjectBean bean) {
        super.build(bean, new HashSet<IMObject>());
        if (this.archetype != null && this.id != null) {
            ActIdentity identity = (ActIdentity)this.service.create(this.archetype, ActIdentity.class);
            identity.setIdentity(this.id);
            act.addIdentity(identity);
        }
        if (this.received != null) {
            bean.setValue("startTime", (Object)DateRules.toDate((OffsetDateTime)this.received));
        }
    }

    protected static void copyMessageDetailsToReply(IMObjectBean message, IMObjectBean reply) {
        ReceivedMessageBuilderImpl.copyReference(message, reply, "contact");
        ReceivedMessageBuilderImpl.copyReference(message, reply, "customer");
        ReceivedMessageBuilderImpl.copyReference(message, reply, "patient");
        ReceivedMessageBuilderImpl.copyReference(message, reply, "location");
    }

    private static void copyReference(IMObjectBean message, IMObjectBean reply, String name) {
        Reference target = message.getTargetRef(name);
        if (target != null) {
            reply.setTarget(name, target);
        }
    }

    private boolean isDuplicate() {
        return SMSMessageHelper.isDuplicateInboundId(this.archetype, this.id, this.service);
    }
}

