/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.practice.Location;
import org.openvpms.sms.internal.message.SMSMessageHelper;
import org.openvpms.sms.message.Message;

public class MessageImpl
implements Message {
    private final Act message;
    private final IMObjectBean bean;
    private final ArchetypeService service;
    private final DomainService domainService;

    public MessageImpl(Act message, ArchetypeService service, DomainService domainService) {
        this(message, service.getBean((IMObject)message), service, domainService);
    }

    public MessageImpl(IMObjectBean message, ArchetypeService service, DomainService domainService) {
        this((Act)message.getObject(Act.class), message, service, domainService);
    }

    private MessageImpl(Act message, IMObjectBean bean, ArchetypeService service, DomainService domainService) {
        this.message = message;
        this.bean = bean;
        this.service = service;
        this.domainService = domainService;
    }

    public long getId() {
        return this.message.getId();
    }

    public String getProviderId() {
        return SMSMessageHelper.getProviderId(this.bean);
    }

    public String getPhone() {
        return this.bean.getString("phone");
    }

    public String getMessage() {
        return this.bean.getString("message");
    }

    public Location getLocation() {
        Party location = (Party)this.bean.getTarget("location", Party.class);
        return location != null ? (Location)this.domainService.create((IMObject)location, Location.class) : null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageImpl) {
            return ((MessageImpl)obj).getAct().equals(this.getAct());
        }
        return false;
    }

    public int hashCode() {
        return this.getAct().hashCode();
    }

    protected ActIdentity getIdentity() {
        return SMSMessageHelper.getProviderIdentity(this.bean);
    }

    protected Act getAct() {
        return this.message;
    }

    protected IMObjectBean getBean() {
        return this.bean;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected DomainService getDomainService() {
        return this.domainService;
    }
}

