/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.service;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.workflow.AppointmentReminderConfig;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.sms.internal.message.ReadStatus;
import org.openvpms.sms.internal.service.InboundSMSProcessor;
import org.openvpms.sms.message.InboundMessage;
import org.openvpms.sms.message.OutboundMessage;

public class AppointmentReplyProcessor
implements InboundSMSProcessor {
    private final ArchetypeService service;
    private final AppointmentRules rules;
    private static final String SMS_STATUS = "smsStatus";

    public AppointmentReplyProcessor(ArchetypeService service, AppointmentRules rules) {
        this.service = service;
        this.rules = rules;
    }

    @Override
    public String getArchetype() {
        return "act.customerAppointment";
    }

    @Override
    public ReadStatus process(InboundMessage inbound, OutboundMessage outbound, Act source) {
        String status;
        ReadStatus result = ReadStatus.PENDING;
        AppointmentReminderConfig config = this.rules.getAppointmentReminderConfig();
        IMObjectBean bean = this.service.getBean((IMObject)source);
        boolean changed = false;
        boolean setToReceived = true;
        if (config != null && config.processReplies() && ("PENDING".equals(status = source.getStatus()) || "CONFIRMED".equals(status) || "CANCELLED".equals(status))) {
            String outboundMessage = outbound.getMessage();
            String inboundMessage = StringUtils.trimToEmpty((String)inbound.getMessage());
            String newStatus = null;
            AppointmentReminderConfig.Match match = config.isConfirmation(inboundMessage, outboundMessage);
            if (match.isMatch()) {
                newStatus = "CONFIRMED";
                if (match == AppointmentReminderConfig.Match.EXACT) {
                    result = ReadStatus.COMPLETED;
                }
            } else {
                match = config.isCancellation(inboundMessage, outboundMessage);
                if (match.isMatch()) {
                    newStatus = "CANCELLED";
                }
            }
            if (newStatus != null) {
                if (newStatus.equals(status)) {
                    setToReceived = AppointmentReminderConfig.Match.EXACT != match;
                } else if (!"CANCELLED".equals(status)) {
                    source.setStatus(newStatus);
                    if (newStatus.equals("CONFIRMED")) {
                        bean.setValue("confirmedTime", (Object)new Date());
                    }
                    changed = true;
                    boolean bl = setToReceived = AppointmentReminderConfig.Match.EXACT != match;
                }
            }
        }
        if (setToReceived && !"RECEIVED".equals(bean.getString(SMS_STATUS))) {
            bean.setValue(SMS_STATUS, (Object)"RECEIVED");
            changed = true;
        }
        if (changed) {
            this.service.save((IMObject)source);
        }
        return result;
    }
}

