/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.internal.i18n.SMSMessages;
import org.openvpms.sms.internal.message.MessageBuilderImpl;
import org.openvpms.sms.internal.message.OutboundMessageImpl;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.message.OutboundMessageBuilder;

public class OutboundMessageBuilderImpl
extends MessageBuilderImpl<OutboundMessageBuilder>
implements OutboundMessageBuilder {
    private final ArchetypeService service;
    private final DomainService domainService;
    private Party recipient;
    private OffsetDateTime expiry;
    private Party customer;
    private Party patient;
    private String subject;
    private String reason;
    private String note;
    private Act source;

    public OutboundMessageBuilderImpl(ArchetypeService service, DomainService domainService) {
        this.service = service;
        this.domainService = domainService;
    }

    public OutboundMessageBuilder recipient(Party recipient) {
        this.recipient = recipient;
        return this;
    }

    public OutboundMessageBuilder expiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public OutboundMessageBuilder customer(Party customer) {
        this.customer = customer;
        return this;
    }

    public OutboundMessageBuilder patient(Party patient) {
        this.patient = patient;
        return this;
    }

    public OutboundMessageBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public OutboundMessageBuilder reason(String reason) {
        this.reason = reason;
        return this;
    }

    public OutboundMessageBuilder note(String note) {
        this.note = note;
        return this;
    }

    public OutboundMessageBuilder source(Act source) {
        this.source = source;
        return this;
    }

    public OutboundMessage build() {
        Act act = (Act)this.service.create("act.smsMessage", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        HashSet<IMObject> objects = new HashSet<IMObject>();
        this.build(bean, objects);
        return new OutboundMessageImpl(bean, this.service, this.domainService, objects);
    }

    @Override
    protected void build(IMObjectBean bean, Set<IMObject> objects) {
        super.build(bean, objects);
        if (StringUtils.trimToNull((String)this.getPhone()) == null) {
            throw new SMSException(SMSMessages.noPhone());
        }
        if (this.recipient != null) {
            bean.setTarget("contact", (IMObject)this.recipient);
        }
        if (this.expiry != null) {
            bean.setValue("expiryTime", (Object)DateRules.toDate((OffsetDateTime)this.expiry));
        }
        if (this.customer == null && this.recipient != null && this.recipient.isA("party.customerperson")) {
            bean.setTarget("customer", (IMObject)this.recipient);
        } else if (this.customer != null) {
            bean.setTarget("customer", (IMObject)this.customer);
        }
        if (this.patient != null) {
            bean.setTarget("patient", (IMObject)this.patient);
        }
        this.setValue(bean, "description", this.subject);
        bean.setValue("reason", (Object)this.reason);
        this.setValue(bean, "note", this.note);
        if (this.source != null) {
            ActRelationship relationship = (ActRelationship)this.service.create("actRelationship.smsSource", ActRelationship.class);
            relationship.setSource(this.source.getObjectReference());
            relationship.setTarget(bean.getReference());
            this.source.addActRelationship(relationship);
            ((Act)bean.getObject(Act.class)).addActRelationship(relationship);
            objects.add((IMObject)this.source);
        }
    }

    private void setValue(IMObjectBean bean, String name, String value) {
        if (value != null) {
            bean.setValue(name, (Object)StringUtils.abbreviate((String)value, (int)bean.getMaxLength(name)));
        }
    }
}

