/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import java.util.Date;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.internal.message.MessagesImpl;
import org.openvpms.sms.internal.message.ReceivedMessageBuilderImpl;
import org.openvpms.sms.message.InboundMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundMessageBuilderImpl
extends ReceivedMessageBuilderImpl<InboundMessageBuilder>
implements InboundMessageBuilder {
    private final MessagesImpl messages;
    private long outboundId;
    private String outboundArchetype;
    private String outboundProviderId;
    private static final Logger log = LoggerFactory.getLogger(InboundMessageBuilderImpl.class);

    public InboundMessageBuilderImpl(ArchetypeService service, DomainService domainService, MessagesImpl messages) {
        super(service, domainService);
        this.messages = messages;
    }

    public InboundMessageBuilder outboundId(long id) {
        this.outboundId = id;
        return this;
    }

    public InboundMessageBuilder outboundProviderId(String archetype, String id) {
        this.outboundArchetype = archetype;
        this.outboundProviderId = id;
        return this;
    }

    @Override
    protected void build(Act act, IMObjectBean bean) {
        super.build(act, bean);
        Act outbound = this.getOutbound();
        if (outbound != null) {
            IMObjectBean original = this.getService().getBean((IMObject)outbound);
            original.setValue("startTime", (Object)new Date());
            InboundMessageBuilderImpl.copyMessageDetailsToReply(original, bean);
            original.addTarget("replies", (IMObject)act, "sms");
            bean.save(new IMObject[]{outbound});
        } else {
            bean.save();
        }
    }

    private Act getOutbound() {
        Act result = null;
        if (this.outboundId > 0L) {
            result = this.messages.getOutbound(this.outboundId);
            if (result == null) {
                log.warn("No outbound message found with id={}. The reply will be saved as an uncorrelated message", (Object)this.outboundId);
            }
        } else if (this.outboundArchetype != null && this.outboundProviderId != null && (result = this.messages.getOutbound(this.outboundArchetype, this.outboundProviderId)) == null) {
            log.warn("No outbound message found with provider archetype={} and id={}. The reply will be saved as an uncorrelated message", (Object)this.outboundArchetype, (Object)this.outboundProviderId);
        }
        return result;
    }
}

