/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.mail.template;

import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.internal.i18n.SMSMessages;
import org.openvpms.sms.internal.mail.MailMessage;
import org.openvpms.sms.internal.mail.MailMessageFactory;
import org.openvpms.sms.internal.mail.template.MailTemplate;
import org.openvpms.sms.internal.mail.template.MailTemplateConfig;
import org.openvpms.sms.internal.mail.template.StaticMailTemplateConfig;

public class TemplatedMailMessageFactory
implements MailMessageFactory {
    private final MailTemplateConfig config;

    public TemplatedMailMessageFactory(MailTemplate template) {
        this(new StaticMailTemplateConfig(template));
    }

    public TemplatedMailMessageFactory(MailTemplateConfig config) {
        this.config = config;
    }

    @Override
    public MailMessage createMessage(String phone, String text) {
        MailMessage result = new MailMessage();
        MailTemplate template = this.config.getTemplate();
        phone = this.getPhone(phone, template);
        JXPathContext context = JXPathHelper.newContext((Object)new Object());
        context.setLenient(false);
        Variables variables = context.getVariables();
        variables.declareVariable("phone", (Object)phone);
        variables.declareVariable("message", (Object)text);
        variables.declareVariable("from", (Object)template.getFrom());
        variables.declareVariable("to", (Object)template.getTo());
        variables.declareVariable("replyTo", (Object)template.getReplyTo());
        variables.declareVariable("subject", (Object)template.getSubject());
        variables.declareVariable("text", (Object)template.getText());
        variables.declareVariable("nl", (Object)"\n");
        for (Map.Entry<String, Object> variable : template.getVariables().entrySet()) {
            variables.declareVariable(variable.getKey(), variable.getValue());
        }
        String from = this.evaluate(template.getFrom(), template.getFromExpression(), context);
        if (from == null || !this.isValid(from)) {
            throw new SMSException(SMSMessages.invalidFromAddress(from));
        }
        result.setFrom(from);
        String to = this.evaluate(template.getTo(), template.getToExpression(), context);
        if (to == null || !this.isValid(to)) {
            throw new SMSException(SMSMessages.invalidToAddress(to));
        }
        result.setTo(to);
        String replyTo = this.evaluate(template.getReplyTo(), template.getReplyToExpression(), context);
        if (replyTo != null) {
            if (!this.isValid(replyTo)) {
                throw new SMSException(SMSMessages.invalidReplyToAddress(replyTo));
            }
            result.setReplyTo(replyTo);
        }
        result.setSubject(this.evaluate(template.getSubject(), template.getSubjectExpression(), context));
        result.setText(this.evaluate(template.getText(), template.getTextExpression(), context));
        if (result.getText() == null) {
            throw new SMSException(SMSMessages.noMessageText());
        }
        return result;
    }

    @Override
    public int getMaxParts() {
        int maxParts = 1;
        try {
            MailTemplate template = this.config.getTemplate();
            maxParts = template.getMaxParts();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxParts;
    }

    protected String getPhone(String phone, MailTemplate template) {
        if (phone != null) {
            if ((phone = StringUtils.remove((String)phone, (char)' ')).startsWith("+")) {
                phone = phone.substring(1);
            } else {
                String prefix = template.getCountryPrefix();
                if (prefix != null && !phone.startsWith(prefix)) {
                    String areaPrefix = template.getAreaPrefix();
                    if (areaPrefix != null && phone.startsWith(areaPrefix)) {
                        phone = phone.substring(areaPrefix.length());
                    }
                    phone = prefix + phone;
                }
            }
        }
        return phone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String evaluate(String text, String expression, JXPathContext context) {
        String result = null;
        if (!StringUtils.isEmpty((CharSequence)expression)) {
            try {
                Object value = context.getValue(expression, Object.class);
                if (value == null) return result;
                return value.toString();
            }
            catch (Throwable exception) {
                throw new SMSException(SMSMessages.failedToEvaluateExpression(expression), exception);
            }
        }
        if (StringUtils.isEmpty((CharSequence)text)) return result;
        return text;
    }

    private boolean isValid(String address) {
        boolean result = false;
        try {
            new InternetAddress(address, true);
            result = true;
        }
        catch (AddressException addressException) {
            // empty catch block
        }
        return result;
    }
}

