/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.mail;

import java.net.ConnectException;
import java.util.Objects;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.internal.i18n.SMSMessages;
import org.openvpms.sms.internal.mail.MailMessage;
import org.openvpms.sms.internal.mail.MailMessageFactory;
import org.openvpms.sms.internal.mail.template.MailTemplate;
import org.openvpms.sms.internal.mail.template.MailTemplateFactory;
import org.openvpms.sms.internal.mail.template.TemplatedMailMessageFactory;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.service.SMSProvider;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;

public class MailSMSProvider
implements SMSProvider {
    private final IArchetypeService service;
    private final JavaMailSender sender;
    private MailMessageFactory factory;
    private Entity lastConfig;

    public MailSMSProvider(IArchetypeService service, JavaMailSender sender) {
        this.service = service;
        this.sender = sender;
    }

    public String getName() {
        return "Mail SMS Provider";
    }

    public String[] getArchetypes() {
        return this.service.getArchetypes("entity.SMSConfigEmail*", true).toArray(new String[0]);
    }

    public void send(OutboundMessage message, Entity config) {
        if (message.getStatus() != OutboundMessage.Status.PENDING) {
            throw new IllegalStateException("Cannot send message with status=" + message.getStatus());
        }
        this.send(message.getPhone(), message.getMessage(), config);
        message.setStatus(OutboundMessage.Status.SENT);
    }

    public void send(String phone, String text, Entity config) {
        MailMessageFactory factory = this.getFactory(config);
        this.send(phone, text, factory);
    }

    public void send(String phone, String text, MailMessageFactory factory) {
        MailMessage message = factory.createMessage(phone, text);
        MimeMessage mime = this.sender.createMimeMessage();
        try {
            message.copyTo(mime);
        }
        catch (MessagingException exception) {
            throw new SMSException(SMSMessages.failedToCreateEmail(exception.getLocalizedMessage()), (Throwable)exception);
        }
        try {
            this.sender.send(mime);
        }
        catch (MailAuthenticationException exception) {
            throw new SMSException(SMSMessages.mailAuthenticationFailed(exception.getLocalizedMessage()), (Throwable)exception);
        }
        catch (MailSendException exception) {
            MessagingException mailEx;
            if (exception.getCause() instanceof MessagingException && (mailEx = (MessagingException)exception.getCause()).getNextException() instanceof ConnectException) {
                throw new SMSException(SMSMessages.mailConnectionFailed(mailEx.getLocalizedMessage()), (Throwable)exception);
            }
            throw new SMSException(SMSMessages.mailSendFailed(exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private synchronized MailMessageFactory getFactory(Entity config) {
        if (this.factory == null || this.lastConfig == null || !Objects.equals(this.lastConfig, config) || this.lastConfig.getVersion() != config.getVersion()) {
            MailTemplate template = new MailTemplateFactory(this.service).getTemplate(config);
            this.factory = new TemplatedMailMessageFactory(template);
            this.lastConfig = config;
        }
        return this.factory;
    }
}

