/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.service;

import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.internal.i18n.SMSMessages;
import org.openvpms.sms.internal.message.OutboundMessageImpl;
import org.openvpms.sms.internal.message.QueueStatus;
import org.openvpms.sms.internal.service.SMSDispatcher;
import org.openvpms.sms.internal.service.SMSQueue;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.service.SMSProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OutboundSMSDispatcher
extends SMSDispatcher {
    private final PluginManager pluginManager;
    private final SMSProvider mailProvider;
    private final DomainService domainService;
    private static final Logger log = LoggerFactory.getLogger(OutboundSMSDispatcher.class);

    public OutboundSMSDispatcher(ArchetypeService service, PluginManager pluginManager, PracticeService practiceService, DomainService domainService, SMSProvider mailProvider) {
        super("act.smsMessage", service, practiceService, log);
        this.pluginManager = pluginManager;
        this.mailProvider = mailProvider;
        this.domainService = domainService;
    }

    public void initialise() {
        this.schedule();
    }

    public void queue(OutboundMessage message) {
        if (message.getStatus() != OutboundMessage.Status.PENDING) {
            throw new IllegalStateException("Cannot queue message with status=" + message.getStatus());
        }
        this.requireConfig();
        ((OutboundMessageImpl)message).queue();
        this.schedule();
    }

    protected Entity requireConfig() {
        Entity config = this.getConfig();
        if (config == null) {
            Party practice = this.getPracticeService().getPractice();
            if (practice == null) {
                throw new SMSException(SMSMessages.practiceNotFound());
            }
            throw new SMSException(SMSMessages.SMSNotConfigured(practice));
        }
        return config;
    }

    protected void process(Act object, SMSQueue queue) {
        Entity config = this.requireConfig();
        SMSProvider provider = this.getProvider(config);
        if (provider != null) {
            OutboundMessageImpl message = new OutboundMessageImpl(object, this.getService(), this.domainService);
            if (message.isExpired()) {
                message.setStatus(OutboundMessage.Status.EXPIRED);
            } else if (message.getQueueStatus() == QueueStatus.QUEUED) {
                provider.send((OutboundMessage)message, config);
            }
        } else {
            throw new SMSException(SMSMessages.providerNotAvailable(config));
        }
        queue.processed();
    }

    protected SMSProvider getProvider(Entity config) {
        SMSProvider result = null;
        String archetype = config.getArchetype();
        if (config.isA(this.mailProvider.getArchetypes())) {
            result = this.mailProvider;
        } else {
            for (SMSProvider provider : this.pluginManager.getServices(SMSProvider.class)) {
                if (ArrayUtils.indexOf((Object[])provider.getArchetypes(), (Object)archetype) == -1) continue;
                result = provider;
                break;
            }
        }
        return result;
    }

    protected Entity getConfig() {
        Entity config = this.getPracticeService().getSMS();
        return config != null && config.isActive() ? config : null;
    }

    protected IMObjectBean getConfigBean() {
        Entity config = this.getConfig();
        return config != null ? this.getService().getBean((IMObject)config) : null;
    }

    protected String toString(Act object) {
        return object.getObjectReference().toString();
    }
}

