/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

class SMSMessageHelper {
    SMSMessageHelper() {
    }

    public static String getProviderId(IMObjectBean message) {
        ActIdentity identity = (ActIdentity)message.getObject("providerId", ActIdentity.class);
        return identity != null ? identity.getIdentity() : null;
    }

    public static ActIdentity getProviderIdentity(IMObjectBean message) {
        return (ActIdentity)message.getObject("providerId", ActIdentity.class);
    }

    public static boolean isDuplicateOutboundId(String archetype, String id, long exclude, ArchetypeService service) {
        return SMSMessageHelper.isDuplicate("act.smsMessage", archetype, id, exclude, service);
    }

    public static boolean isDuplicateInboundId(String archetype, String id, ArchetypeService service) {
        return SMSMessageHelper.isDuplicate("act.smsReply", archetype, id, -1L, service);
    }

    private static boolean isDuplicate(String messageArchetype, String idArchetype, String id, long exclude, ArchetypeService service) {
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root root = query.from(Act.class, new String[]{messageArchetype});
        Join providerId = root.join("providerId", idArchetype);
        providerId.on((Expression)builder.equal((Expression)providerId.get("identity"), (Object)id));
        if (exclude > 0L) {
            query.where((Expression)builder.notEqual((Expression)root.get("id"), (Object)exclude));
        }
        query.select((Selection)root.get("id"));
        return service.createQuery(query).getFirstResult() != null;
    }
}

