/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.internal.message.InboundMessageImpl;
import org.openvpms.sms.internal.message.MessageImpl;
import org.openvpms.sms.internal.message.QueueStatus;
import org.openvpms.sms.internal.message.StateBuilderImpl;
import org.openvpms.sms.message.InboundMessage;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.message.ReplyBuilder;
import org.openvpms.sms.message.StateBuilder;

public class OutboundMessageImpl
extends MessageImpl
implements OutboundMessage {
    private final Set<IMObject> objects;

    public OutboundMessageImpl(Act message, ArchetypeService service, DomainService domainService) {
        super(message, service, domainService);
        this.objects = null;
    }

    public OutboundMessageImpl(IMObjectBean message, ArchetypeService service, DomainService domainService, Set<IMObject> objects) {
        super(message, service, domainService);
        this.objects = objects;
    }

    public OffsetDateTime getCreated() {
        return DateRules.toOffsetDateTime((Date)this.getBean().getDate("createdTime"));
    }

    public OffsetDateTime getUpdated() {
        return DateRules.toOffsetDateTime((Date)this.getBean().getDate("startTime"));
    }

    public OffsetDateTime getExpiry() {
        Date date = this.getExpiryDate();
        return date != null ? DateRules.toOffsetDateTime((Date)date) : null;
    }

    public boolean isExpired() {
        boolean result = false;
        OutboundMessage.Status status = this.getStatus();
        Date date = this.getExpiryDate();
        if (date != null && status == OutboundMessage.Status.PENDING) {
            result = date.before(new Date());
        }
        return result;
    }

    public OffsetDateTime getSent() {
        Date date = this.getBean().getDate("endTime");
        return date != null ? DateRules.toOffsetDateTime((Date)date) : null;
    }

    public Party getRecipient() {
        return (Party)this.getBean().getTarget("contact", Party.class);
    }

    public OutboundMessage.Status getStatus() {
        return OutboundMessage.Status.valueOf((String)this.getAct().getStatus());
    }

    public void setStatus(OutboundMessage.Status status) {
        this.setStatus(status, null);
    }

    public String getStatusMessage() {
        return this.getBean().getString("statusMessage");
    }

    public void setStatus(OutboundMessage.Status status, String statusMessage) {
        this.state().status(status, statusMessage).build();
    }

    public boolean canTransition(OutboundMessage.Status status) {
        OutboundMessage.Status current = this.getStatus();
        return current.canTransition(status);
    }

    public boolean hasReply(String providerId) {
        for (InboundMessage reply : this.getReplies()) {
            if (!providerId.equals(reply.getProviderId())) continue;
            return true;
        }
        return false;
    }

    public List<InboundMessage> getReplies() {
        ArrayList<InboundMessage> result = new ArrayList<InboundMessage>();
        for (Act act : this.getBean().getTargets("replies", Act.class)) {
            result.add(new InboundMessageImpl(act, this.getService(), this.getDomainService()));
        }
        return result;
    }

    public StateBuilder state() {
        return new StateBuilderImpl(this, this.getBean(), this.getService(), this.getDomainService());
    }

    public ReplyBuilder reply() {
        return this.state().reply();
    }

    public void queue() {
        Act message = this.getAct();
        if (this.getStatus() != OutboundMessage.Status.PENDING) {
            throw new IllegalStateException("Cannot queue message with status=" + message.getStatus());
        }
        if (this.getQueueStatus() == QueueStatus.PENDING) {
            message.setStatus2(QueueStatus.QUEUED.toString());
            this.setUpdated();
            this.save();
        }
    }

    public QueueStatus getQueueStatus() {
        return QueueStatus.valueOf(this.getAct().getStatus2());
    }

    protected Date getExpiryDate() {
        return this.getBean().getDate("expiryTime");
    }

    void setUpdated() {
        this.getBean().setValue("startTime", (Object)new Date());
    }

    private void save() {
        IMObjectBean bean = this.getBean();
        if (this.objects != null) {
            bean.save(this.objects);
        } else {
            bean.save();
        }
    }
}

