/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.message;

import java.time.OffsetDateTime;
import java.util.Iterator;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.internal.message.InboundMessageBuilderImpl;
import org.openvpms.sms.internal.message.InboundMessageImpl;
import org.openvpms.sms.internal.message.OutboundMessageBuilderImpl;
import org.openvpms.sms.internal.message.OutboundMessageImpl;
import org.openvpms.sms.internal.service.SMSLengthCalculator;
import org.openvpms.sms.message.InboundMessage;
import org.openvpms.sms.message.InboundMessageBuilder;
import org.openvpms.sms.message.Messages;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.message.OutboundMessageBuilder;

public class MessagesImpl
implements Messages {
    private final ArchetypeService service;
    private final DomainService domainService;

    public MessagesImpl(ArchetypeService service, DomainService domainService) {
        this.service = service;
        this.domainService = domainService;
    }

    public int getParts(String message) {
        return SMSLengthCalculator.getParts(message);
    }

    public OutboundMessageBuilder getOutboundMessageBuilder() {
        return new OutboundMessageBuilderImpl(this.service, this.domainService);
    }

    public OutboundMessage getOutboundMessage(long id) {
        Act act = this.getOutbound(id);
        return act != null ? new OutboundMessageImpl(act, this.service, this.domainService) : null;
    }

    public OutboundMessage getOutboundMessage(String archetype, String id) {
        Act act = this.getOutbound(archetype, id);
        return act != null ? new OutboundMessageImpl(act, this.service, this.domainService) : null;
    }

    public Iterable<OutboundMessage> getSent(OffsetDateTime from, String archetype) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{"act.smsMessage"});
        root.join("providerId", archetype);
        query.where(new Predicate[]{builder.equal((Expression)root.get("status"), (Object)OutboundMessage.Status.SENT.toString()), builder.greaterThanOrEqualTo((Expression)root.get("endTime"), (Comparable)DateRules.toDate((OffsetDateTime)from))});
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return new MessageIterable((CriteriaQuery<Act>)query);
    }

    public InboundMessage getInboundMessage(long id) {
        Act act = (Act)this.service.get("act.smsReply", id, Act.class);
        return act != null ? new InboundMessageImpl(act, this.service, this.domainService) : null;
    }

    public InboundMessage getInboundMessage(String archetype, String id) {
        Act act = this.getMessage("act.smsReply", archetype, id);
        return act != null ? new InboundMessageImpl(act, this.service, this.domainService) : null;
    }

    public InboundMessageBuilder getInboundMessageBuilder() {
        return new InboundMessageBuilderImpl(this.service, this.domainService, this);
    }

    public Act getOutbound(long id) {
        return (Act)this.service.get("act.smsMessage", id, Act.class);
    }

    public Act getOutbound(String archetype, String id) {
        return this.getMessage("act.smsMessage", archetype, id);
    }

    private Act getMessage(String archetype, String idArchetype, String id) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{archetype});
        Join providerId = root.join("providerId", idArchetype);
        providerId.on((Expression)builder.equal((Expression)providerId.get("identity"), (Object)id));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (Act)this.service.createQuery(query).getFirstResult();
    }

    private class MessageIterator
    implements Iterator<OutboundMessage> {
        private final Iterator<Act> iterator;

        public MessageIterator(Iterator<Act> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public OutboundMessage next() {
            Act act = this.iterator.next();
            return new OutboundMessageImpl(act, MessagesImpl.this.service, MessagesImpl.this.domainService);
        }
    }

    private class MessageIterable
    implements Iterable<OutboundMessage> {
        private final CriteriaQuery<Act> query;

        public MessageIterable(CriteriaQuery<Act> query) {
            this.query = query;
        }

        @Override
        public Iterator<OutboundMessage> iterator() {
            TypedQuery typed = MessagesImpl.this.service.createQuery(this.query);
            return new MessageIterator((Iterator<Act>)new TypedQueryIterator(typed, 100));
        }
    }
}

