/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.mail.template;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.sms.internal.mail.template.MailTemplate;

public class MailTemplateFactory {
    private final IArchetypeService service;
    private static final String[] RESERVED = new String[]{"name", "description", "website", "from", "fromExpression", "to", "toExpression", "replyTo", "replyToExpression", "subject", "subjectExpression", "text", "textExpression", "phone", "message", "active"};

    public MailTemplateFactory(IArchetypeService service) {
        this.service = service;
    }

    public MailTemplate getTemplate(Entity config) {
        IMObjectBean configBean = this.service.getBean((IMObject)config);
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(config.getArchetype());
        MailTemplate result = new MailTemplate();
        result.setCountryPrefix(this.getString(configBean, "countryPrefix"));
        result.setAreaPrefix(this.getString(configBean, "areaPrefix"));
        result.setFrom(this.getString(configBean, "from"));
        result.setFromExpression(this.getString(configBean, "fromExpression"));
        result.setTo(this.getString(configBean, "to"));
        result.setToExpression(this.getString(configBean, "toExpression"));
        result.setReplyTo(this.getString(configBean, "replyTo"));
        result.setReplyToExpression(this.getString(configBean, "replyToExpression"));
        result.setSubject(this.getString(configBean, "subject"));
        result.setSubjectExpression(this.getString(configBean, "subjectExpression"));
        result.setText(this.getString(configBean, "text"));
        result.setTextExpression(this.getString(configBean, "textExpression"));
        int maxParts = 1;
        if (configBean.hasNode("parts") && (maxParts = configBean.getInt("parts", 1)) < 1) {
            maxParts = 1;
        }
        result.setMaxParts(maxParts);
        for (org.openvpms.component.model.archetype.NodeDescriptor descriptor : archetype.getNodeDescriptors()) {
            String type = descriptor.getType();
            if (!String.class.getName().equals(type) && !Boolean.class.getName().equals(type) || ArrayUtils.contains((Object[])RESERVED, (Object)descriptor.getName())) continue;
            Object value = ((NodeDescriptor)descriptor).getValue((IMObject)config);
            result.addVariable(descriptor.getName(), value);
        }
        return result;
    }

    private String getString(IMObjectBean bean, String name) {
        String result = null;
        if (bean.hasNode(name)) {
            result = StringUtils.trimToNull((String)bean.getString(name));
        }
        return result;
    }
}

