/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.service;

import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.internal.message.InboundMessageImpl;
import org.openvpms.sms.internal.message.OutboundMessageImpl;
import org.openvpms.sms.internal.message.QueueStatus;
import org.openvpms.sms.internal.message.ReadStatus;
import org.openvpms.sms.internal.service.InboundSMSProcessor;
import org.openvpms.sms.internal.service.InboundSMSProcessorFactory;
import org.openvpms.sms.internal.service.SMSDispatcher;
import org.openvpms.sms.internal.service.SMSQueue;
import org.openvpms.sms.message.InboundMessage;
import org.openvpms.sms.message.OutboundMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class InboundSMSDispatcher
extends SMSDispatcher {
    private final DomainService domainService;
    private final InboundSMSProcessorFactory factory;
    private final AbstractArchetypeServiceListener listener;
    private final PlatformTransactionManager transactionManager;
    private static final Logger log = LoggerFactory.getLogger(InboundSMSDispatcher.class);
    private static final String QUEUED = QueueStatus.QUEUED.toString();

    public InboundSMSDispatcher(IArchetypeRuleService service, PracticeService practiceService, DomainService domainService, InboundSMSProcessorFactory factory, PlatformTransactionManager transactionManager) {
        super("act.smsReply", (ArchetypeService)service, practiceService, log);
        this.domainService = domainService;
        this.factory = factory;
        this.transactionManager = transactionManager;
        this.listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                InboundSMSDispatcher.this.schedule();
            }
        };
        service.addListener("act.smsReply", (IArchetypeServiceListener)this.listener);
    }

    public void destroy() throws Exception {
        try {
            super.destroy();
        }
        finally {
            ((IArchetypeRuleService)this.getService()).removeListener("act.smsReply", (IArchetypeServiceListener)this.listener);
        }
    }

    protected void process(Act object, SMSQueue queue) throws Exception {
        if (QUEUED.equals(object.getStatus2())) {
            InboundSMSProcessor processor;
            Act source;
            boolean processed = false;
            ArchetypeService service = this.getService();
            InboundMessageImpl inbound = new InboundMessageImpl(object, service, this.domainService);
            Act outboundAct = this.getOutboundAct(inbound);
            if (outboundAct != null && (source = (Act)service.getBean((IMObject)outboundAct).getSource("source", Act.class)) != null && (processor = this.factory.getProcessor(source.getArchetype())) != null) {
                OutboundMessageImpl outbound = new OutboundMessageImpl(outboundAct, service, this.domainService);
                this.process(inbound, object, outbound, source, processor);
                processed = true;
            }
            if (!processed) {
                this.completed(object, null);
            }
        }
        queue.processed();
    }

    private void process(final InboundMessage inbound, final Act inboundAct, final OutboundMessage outbound, final Act source, final InboundSMSProcessor processor) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ReadStatus readStatus = processor.process(inbound, outbound, source);
                InboundSMSDispatcher.this.completed(inboundAct, readStatus);
            }
        });
    }

    private void completed(Act act, ReadStatus readStatus) {
        act.setStatus2(QueueStatus.COMPLETED.name());
        if (readStatus != null) {
            act.setStatus(readStatus.name());
        }
        this.getService().save((IMObject)act);
    }

    private Act getOutboundAct(InboundMessage inbound) {
        Act result = null;
        long id = inbound.getOutboundId();
        if (id != -1L) {
            ArchetypeService service = this.getService();
            result = (Act)service.get("act.smsMessage", id, Act.class);
        }
        return result;
    }
}

