/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.event.EventStatus;
import org.openvpms.smartflow.event.SmartFlowSheetEventService;
import org.openvpms.smartflow.event.impl.QueueDispatcherFactory;
import org.openvpms.smartflow.event.impl.QueueDispatchers;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;

public class SmartFlowSheetEventServiceImpl
implements InitializingBean,
DisposableBean,
SmartFlowSheetEventService {
    private final IArchetypeService service;
    private final PracticeService practiceService;
    private final ExecutorService updateService;
    private final IArchetypeServiceListener listener;
    private final QueueDispatcherFactory dispatcherFactory;
    private QueueDispatchers dispatchers;

    protected SmartFlowSheetEventServiceImpl(FlowSheetServiceFactory factory, IArchetypeService service, LookupService lookups, PracticeService practiceService, PlatformTransactionManager transactionManager, PatientRules rules) {
        this.service = service;
        this.practiceService = practiceService;
        this.updateService = Executors.newSingleThreadExecutor();
        this.listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                SmartFlowSheetEventServiceImpl.this.updateService.execute(() -> SmartFlowSheetEventServiceImpl.this.locationSaved((Party)object));
            }

            public void removed(IMObject object) {
                SmartFlowSheetEventServiceImpl.this.updateService.execute(() -> SmartFlowSheetEventServiceImpl.this.locationRemoved((Party)object));
            }
        };
        this.dispatcherFactory = new QueueDispatcherFactory(factory, service, lookups, transactionManager, practiceService, rules);
        this.init();
    }

    @Override
    public void start() {
        this.dispatchers.start();
    }

    @Override
    public synchronized EventStatus getStatus(Party location) {
        return this.dispatchers.getStatus(location);
    }

    @Override
    public synchronized void restart() {
        this.dispatchers.destroy();
        this.init();
        this.addLocations();
        this.start();
    }

    public void afterPropertiesSet() {
        this.addLocations();
        this.service.addListener("party.organisationLocation", this.listener);
        this.start();
    }

    public void destroy() {
        this.service.removeListener("party.organisationLocation", this.listener);
        this.dispatchers.destroy();
        this.updateService.shutdown();
    }

    private void init() {
        this.dispatchers = new QueueDispatchers(this.dispatcherFactory);
    }

    private void addLocations() {
        for (Party location : this.practiceService.getLocations()) {
            this.dispatchers.add(location);
        }
    }

    private synchronized void locationSaved(Party location) {
        this.dispatchers.add(location);
    }

    private synchronized void locationRemoved(Party location) {
        this.dispatchers.remove(location);
    }
}

