/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.smartflow.event.impl.EventProcessor;
import org.openvpms.smartflow.model.InventoryItem;
import org.openvpms.smartflow.model.InventoryItems;
import org.openvpms.smartflow.model.event.InventoryImportedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryImportedEventProcessor
extends EventProcessor<InventoryImportedEvent> {
    private static final Logger log = LoggerFactory.getLogger(InventoryImportedEventProcessor.class);

    public InventoryImportedEventProcessor(IArchetypeService service) {
        super(service);
    }

    @Override
    public void process(InventoryImportedEvent event) {
        InventoryItems object = (InventoryItems)event.getObject();
        if (object != null && object.getInventoryitems() != null) {
            this.imported(object.getInventoryitems());
        }
    }

    private void imported(List<InventoryItem> items) {
        for (InventoryItem item : items) {
            if (item.getAsyncOperationStatus() != null && item.getAsyncOperationStatus() < 0) {
                log.error("Failed to synchronize product=[id=" + item.getId() + ", name=" + item.getName() + "]: " + item.getAsyncOperationMessage());
                continue;
            }
            log.info("Synchronized product=[id=" + item.getId() + ", name=" + item.getName() + "]");
        }
    }
}

