/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.smartflow.event.impl.EventProcessor;
import org.openvpms.smartflow.model.Anesthetic;
import org.openvpms.smartflow.model.Anesthetics;
import org.openvpms.smartflow.model.event.AnestheticsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnestheticsEventProcessor
extends EventProcessor<AnestheticsEvent> {
    private final FlowSheetServiceFactory factory;
    private static final Logger log = LoggerFactory.getLogger(AnestheticsEventProcessor.class);

    public AnestheticsEventProcessor(IArchetypeService service, FlowSheetServiceFactory factory) {
        super(service);
        this.factory = factory;
    }

    @Override
    public void process(AnestheticsEvent event) {
        String apiKey = event.getClinicApiKey();
        HospitalizationService service = this.factory.getHospitalizationService(apiKey);
        Anesthetics anesthetics = (Anesthetics)event.getObject();
        for (Anesthetic anesthetic : anesthetics.getAnesthetics()) {
            this.finalised(anesthetic, service);
        }
    }

    protected void finalised(Anesthetic anesthetic, HospitalizationService service) {
        String reportPath = anesthetic.getReportPath();
        if (!StringUtils.isEmpty((CharSequence)reportPath)) {
            Act visit = this.getVisit(anesthetic.getHospitalizationId());
            if (visit != null) {
                Party patient = this.getPatient(visit);
                if (patient != null) {
                    service.saveAnestheticReports(patient, visit, anesthetic);
                }
            } else {
                log.error("No visit for anesthetic: " + this.toString(anesthetic));
            }
        } else {
            log.error("No reportPath for anesthetic: " + this.toString(anesthetic));
        }
    }

    private String toString(Anesthetic anesthetic) {
        return "hospitalizationId=" + anesthetic.getHospitalizationId();
    }
}

