/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.service;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.openvpms.smartflow.model.Anesthetics;
import org.openvpms.smartflow.model.DentalCharts;
import org.openvpms.smartflow.model.Form;
import org.openvpms.smartflow.model.Hospitalization;

@Path(value="/hospitalization")
public interface Hospitalizations {
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Hospitalization add(Hospitalization var1);

    @GET
    @Path(value="/{hospitalizationId}")
    @Produces(value={"application/json"})
    public Hospitalization get(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/anesthetics")
    @Produces(value={"application/json"})
    public Anesthetics getAnesthetics(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/dentalcharts")
    @Produces(value={"application/json"})
    public DentalCharts getDentalCharts(@PathParam(value="hospitalizationId") String var1);

    @POST
    @Path(value="/discharge/{hospitalizationId}")
    @Produces(value={"application/json"})
    public Hospitalization discharge(@PathParam(value="hospitalizationId") String var1, String var2);

    @DELETE
    @Path(value="/{hospitalizationId}")
    public void remove(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/forms")
    @Produces(value={"application/json"})
    public List<Form> getForms(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/medicalrecordsreport")
    @Produces(value={"application/pdf"})
    public Response getMedicalRecordsReport(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/billingreport")
    @Produces(value={"application/pdf"})
    public Response getBillingReport(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/notesreport")
    @Produces(value={"application/pdf"})
    public Response getNotesReport(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/flowsheetreport")
    @Produces(value={"application/pdf"})
    public Response getFlowSheetReport(@PathParam(value="hospitalizationId") String var1);

    @GET
    @Path(value="/{hospitalizationId}/formreport/{formGuid}")
    @Produces(value={"application/pdf"})
    public Response getFormReport(@PathParam(value="hospitalizationId") String var1, @PathParam(value="formGuid") String var2);
}

