/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.event.EventDispatcher;
import org.openvpms.smartflow.event.impl.DefaultEventDispatcher;
import org.openvpms.smartflow.event.impl.QueueDispatcher;
import org.springframework.transaction.PlatformTransactionManager;

class QueueDispatcherFactory {
    private final FlowSheetServiceFactory factory;
    private final IArchetypeService service;
    private final LookupService lookups;
    private final PlatformTransactionManager transactionManager;
    private final PracticeService practiceService;
    private final PatientRules rules;
    private final ObjectMapper mapper;
    private final ExecutorService executorService;
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("SFS Event Dispatcher").setDaemon(true).build();

    public QueueDispatcherFactory(FlowSheetServiceFactory factory, IArchetypeService service, LookupService lookups, PlatformTransactionManager transactionManager, PracticeService practiceService, PatientRules rules) {
        this.factory = factory;
        this.service = service;
        this.lookups = lookups;
        this.transactionManager = transactionManager;
        this.practiceService = practiceService;
        this.rules = rules;
        this.mapper = new ObjectMapper();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
    }

    public QueueDispatcher createQueueDispatcher(Party location) {
        EventDispatcher dispatcher = this.createEventDispatcher(location);
        return new QueueDispatcher(location, dispatcher, this.mapper, this.executorService, this.factory);
    }

    public String getClinicAPIKey(Party location) {
        return this.factory.getClinicAPIKey(location);
    }

    protected EventDispatcher createEventDispatcher(Party location) {
        return new DefaultEventDispatcher(location, this.service, this.lookups, this.factory, this.practiceService, this.rules, this.transactionManager);
    }
}

