/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.smartflow.client.AccessToDocumentDeniedException;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.smartflow.event.impl.EventProcessor;
import org.openvpms.smartflow.event.impl.FlowSheetConfig;
import org.openvpms.smartflow.event.impl.FlowSheetConfigService;
import org.openvpms.smartflow.model.Hospitalization;
import org.openvpms.smartflow.model.Hospitalizations;
import org.openvpms.smartflow.model.Patient;
import org.openvpms.smartflow.model.event.DischargeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DischargeEventProcessor
extends EventProcessor<DischargeEvent> {
    private final FlowSheetServiceFactory factory;
    private final FlowSheetConfigService configService;
    private static final Logger log = LoggerFactory.getLogger(DischargeEventProcessor.class);

    public DischargeEventProcessor(IArchetypeService service, FlowSheetServiceFactory factory, FlowSheetConfigService configService) {
        super(service);
        this.factory = factory;
        this.configService = configService;
    }

    @Override
    public void process(DischargeEvent event) {
        Hospitalizations list = (Hospitalizations)event.getObject();
        String apiKey = event.getClinicApiKey();
        FlowSheetConfig config = this.configService.getConfig();
        if (this.saveReportsOnDischarge(config)) {
            for (Hospitalization hospitalization : list.getHospitalizations()) {
                this.discharged(hospitalization, apiKey, config);
            }
        } else {
            log.debug("Saving reports on discharge is disabled");
        }
    }

    protected void discharged(Hospitalization hospitalization, String apiKey, FlowSheetConfig config) {
        String reportPath = hospitalization.getReportPath();
        if (!StringUtils.isEmpty((CharSequence)reportPath)) {
            Act visit = this.getVisit(hospitalization.getHospitalizationId());
            if (visit != null) {
                Party patient = this.getPatient(visit);
                if (patient != null) {
                    this.saveReports(patient, visit, hospitalization, apiKey, config);
                }
            } else {
                log.error("No visit for hospitalization: " + this.toString(hospitalization));
            }
        } else {
            log.error("No reportPath for hospitalization: " + this.toString(hospitalization));
        }
    }

    protected void saveReports(Party patient, Act visit, Hospitalization hospitalization, String apiKey, FlowSheetConfig config) {
        HospitalizationService service = this.factory.getHospitalizationService(apiKey);
        User clinician = this.getClinician(hospitalization);
        if (config.isSaveFlowSheetReportOnDischarge()) {
            this.saveFlowSheet(patient, visit, clinician, service);
        }
        if (config.isSaveMedicalRecordsReportOnDischarge()) {
            this.saveMedicalRecords(patient, visit, clinician, service);
        }
        if (config.isSaveBillingReportOnDischarge()) {
            this.saveBillingReport(patient, visit, clinician, service);
        }
        if (config.isSaveNotesReportOnDischarge()) {
            this.saveNotesReport(patient, visit, clinician, service);
        }
        if (config.isSaveFormsReportsOnDischarge()) {
            this.saveForms(patient, visit, clinician, service);
        }
        if (config.isSaveAnestheticsReportsOnDischarge()) {
            this.saveAnestheticsReports(patient, visit, service);
        }
        if (config.isSaveDentalReportsOnDischarge()) {
            this.saveDentalReports(patient, visit, clinician, service);
        }
    }

    protected User getClinician(Hospitalization hospitalization) {
        return (User)this.getObject(hospitalization.getMedicId(), "security.user");
    }

    private boolean saveReportsOnDischarge(FlowSheetConfig config) {
        return config.isSaveFlowSheetReportOnDischarge() || config.isSaveMedicalRecordsReportOnDischarge() || config.isSaveBillingReportOnDischarge() || config.isSaveNotesReportOnDischarge() || config.isSaveFormsReportsOnDischarge() || config.isSaveAnestheticsReportsOnDischarge();
    }

    private void saveFlowSheet(Party patient, Act visit, User clinician, HospitalizationService service) {
        this.runProtected(patient, "flow sheet", () -> service.saveFlowSheetReport(patient, visit, clinician));
    }

    private void saveMedicalRecords(Party patient, Act visit, User clinician, HospitalizationService service) {
        this.runProtected(patient, "medical records", () -> service.saveMedicalRecordsReport(patient, visit, clinician));
    }

    private void saveBillingReport(Party patient, Act visit, User clinician, HospitalizationService service) {
        this.runProtected(patient, "billing report", () -> service.saveBillingReport(patient, visit, clinician));
    }

    private void saveNotesReport(Party patient, Act visit, User clinician, HospitalizationService service) {
        this.runProtected(patient, "notes report", () -> service.saveNotesReport(patient, visit, clinician));
    }

    private void saveForms(Party patient, Act visit, User clinician, HospitalizationService service) {
        this.runProtected(patient, "forms report", () -> service.saveFormsReports(patient, visit, clinician));
    }

    private void saveAnestheticsReports(Party patient, Act visit, HospitalizationService service) {
        this.runProtected(patient, "anesthetics", () -> service.saveAnestheticsReports(patient, visit));
    }

    private void saveDentalReports(Party patient, Act visit, User clinician, HospitalizationService service) {
        this.runProtected(patient, "dental", () -> service.saveDentalReports(patient, visit, clinician));
    }

    private void runProtected(Party patient, String reportName, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AccessToDocumentDeniedException exception) {
            log.warn("Unable to save " + reportName + " for patient=[id=" + patient.getId() + ", name=" + patient.getName() + "]. Accesss is denied", (Throwable)((Object)exception));
        }
    }

    private String toString(Hospitalization hospitalization) {
        Patient patient = hospitalization.getPatient();
        String patientId = patient != null ? patient.getPatientId() : null;
        String patientName = patient != null ? patient.getName() : null;
        return "hospitalizationId=" + hospitalization.getHospitalizationId() + ", patient=[id=" + patientId + ", name=" + patientName + "]";
    }
}

