/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductQueryFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectBeanQueryIterator;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.smartflow.client.FlowSheetService;
import org.openvpms.smartflow.client.SyncState;
import org.openvpms.smartflow.i18n.FlowSheetMessages;
import org.openvpms.smartflow.model.InventoryItem;
import org.openvpms.smartflow.model.InventoryItems;
import org.openvpms.smartflow.service.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryService
extends FlowSheetService {
    private final IArchetypeService service;
    private final LookupService lookups;
    private static final Logger log = LoggerFactory.getLogger(InventoryService.class);

    public InventoryService(String url, String emrApiKey, String clinicApiKey, TimeZone timeZone, IArchetypeService service, LookupService lookups) {
        super(url, emrApiKey, clinicApiKey, timeZone, 120, LoggerFactory.getLogger(InventoryService.class));
        this.service = service;
        this.lookups = lookups;
    }

    public List<InventoryItem> getInventory() {
        FlowSheetService.Call<List<InventoryItem>, Inventory> call = new FlowSheetService.Call<List<InventoryItem>, Inventory>(){

            @Override
            public List<InventoryItem> call(Inventory service) {
                List<InventoryItem> result = service.getInventory();
                if (result == null) {
                    result = Collections.emptyList();
                }
                return result;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetInventory();
            }
        };
        return this.call(Inventory.class, call);
    }

    public void update(final List<InventoryItem> items, final UUID eventId) {
        FlowSheetService.Call<Void, Inventory> call = new FlowSheetService.Call<Void, Inventory>(){

            @Override
            public Void call(Inventory service) {
                InventoryItems inventory = new InventoryItems();
                inventory.setInventoryitems(items);
                inventory.setId(eventId.toString());
                service.update(inventory);
                return null;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToUpdateInventory();
            }
        };
        this.call(Inventory.class, call);
    }

    public void remove(final InventoryItem item) {
        FlowSheetService.Call<Void, Inventory> call = new FlowSheetService.Call<Void, Inventory>(){

            @Override
            public Void call(Inventory service) {
                service.remove(item.getId());
                return null;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToRemoveInventoryItem(item.getId(), item.getName());
            }
        };
        this.call(Inventory.class, call);
    }

    public SyncState synchronise(boolean useLocationProducts, Party location, Party stockLocation) {
        int added = 0;
        int updated = 0;
        int removed = 0;
        Map<String, InventoryItem> inventoryItems = this.getInventoryItems();
        ArrayList<InventoryItem> add = new ArrayList<InventoryItem>();
        Iterator<Product> products = this.getProducts(useLocationProducts, location, stockLocation);
        Map<String, String> units = this.getUnits();
        while (products.hasNext()) {
            String id;
            InventoryItem currentItem;
            Product product = products.next();
            InventoryItem updatedItem = this.synchronise(product, currentItem = inventoryItems.remove(id = Long.toString(product.getId())), id, units);
            if (updatedItem == null) continue;
            add.add(updatedItem);
            if (currentItem == null) {
                ++added;
                continue;
            }
            ++updated;
        }
        if (!add.isEmpty()) {
            log.info("synchronise: adding " + added + " new products, updating " + updated + " existing products");
            this.update(add, UUID.randomUUID());
        } else {
            log.info("synchronise: there are no products to add/update");
        }
        if (!inventoryItems.isEmpty()) {
            log.info("synchronise: removing " + inventoryItems.size() + " products");
            for (InventoryItem item : inventoryItems.values()) {
                this.remove(item);
                ++removed;
            }
        } else {
            log.info("synchronise: there are no products to remove");
        }
        return new SyncState(added, updated, removed);
    }

    private Map<String, InventoryItem> getInventoryItems() {
        HashMap<String, InventoryItem> result = new HashMap<String, InventoryItem>();
        List<InventoryItem> items = this.getInventory();
        for (InventoryItem item : items) {
            result.put(item.getId(), item);
        }
        return result;
    }

    private Iterator<Product> getProducts(boolean useLocationProducts, Party location, Party stockLocation) {
        Set<Reference> productTypes = this.getSynchronisableProductTypes();
        String[] archetypes = new String[]{"product.medication", "product.service", "product.merchandise"};
        ArchetypeQuery query = ProductQueryFactory.create((String[])archetypes, null, null, (boolean)useLocationProducts, (Party)location, (Party)stockLocation);
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(-1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        Predicate predicate = object -> {
            boolean result = false;
            IMObjectBean bean = this.service.getBean((IMObject)object);
            if (!bean.getBoolean("templateOnly")) {
                Reference type = bean.getTargetRef("type");
                result = type == null || productTypes.contains(type);
            }
            return result;
        };
        return new FilterIterator((Iterator)iterator, predicate);
    }

    private Set<Reference> getSynchronisableProductTypes() {
        HashSet<Reference> result = new HashSet<Reference>();
        ArchetypeQuery query = new ArchetypeQuery("entity.productType", true);
        IMObjectBeanQueryIterator iterator = new IMObjectBeanQueryIterator(this.service, query);
        while (iterator.hasNext()) {
            org.openvpms.component.business.service.archetype.helper.IMObjectBean bean = iterator.next();
            if (!bean.getBoolean("synchroniseWithSFS")) continue;
            result.add(bean.getObject().getObjectReference());
        }
        return result;
    }

    private InventoryItem synchronise(Product product, InventoryItem item, String id, Map<String, String> units) {
        InventoryItem result = null;
        String name = product.getName();
        BigDecimal concentration = null;
        String concentrationUnits = null;
        String dispensingUnits = null;
        if (TypeHelper.isA((IMObject)product, (String)"product.medication")) {
            IMObjectBean bean = this.service.getBean((IMObject)product);
            concentration = bean.getBigDecimal("concentration");
            concentrationUnits = this.getUnit(bean.getString("concentrationUnits"), units);
            dispensingUnits = this.getUnit(bean.getString("dispensingUnits"), units);
            if (concentration == null || concentrationUnits == null || dispensingUnits == null) {
                concentration = null;
                concentrationUnits = null;
                dispensingUnits = null;
            }
        }
        if (!(item != null && Objects.equals(name, item.getName()) && MathRules.equals((BigDecimal)concentration, (BigDecimal)item.getConcentration()) && Objects.equals(concentrationUnits, item.getConcentrationUnits()) && Objects.equals(dispensingUnits, item.getConcentrationVolume()))) {
            result = this.createItem(id, name, concentration, concentrationUnits, dispensingUnits);
        }
        return result;
    }

    private InventoryItem createItem(String id, String name, BigDecimal concentration, String concentrationUnits, String dispensingUnits) {
        InventoryItem item = new InventoryItem();
        item.setId(id);
        item.setName(name);
        item.setConcentration(concentration);
        item.setConcentrationUnits(concentrationUnits);
        item.setConcentrationVolume(dispensingUnits);
        return item;
    }

    private String getUnit(String code, Map<String, String> units) {
        String name = units.get(code);
        return name != null ? name.toLowerCase() : code;
    }

    private Map<String, String> getUnits() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Lookup lookup : this.lookups.getLookups("lookup.uom")) {
            result.put(lookup.getCode(), lookup.getName());
        }
        return result;
    }
}

