/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.smartflow.client.AccessToDocumentDeniedException;
import org.openvpms.smartflow.client.FlowSheetException;
import org.openvpms.smartflow.client.FlowSheetService;
import org.openvpms.smartflow.event.impl.SmartFlowSheetHelper;
import org.openvpms.smartflow.i18n.FlowSheetMessages;
import org.openvpms.smartflow.model.Address;
import org.openvpms.smartflow.model.Anesthetic;
import org.openvpms.smartflow.model.Anesthetics;
import org.openvpms.smartflow.model.Client;
import org.openvpms.smartflow.model.DentalChart;
import org.openvpms.smartflow.model.DentalCharts;
import org.openvpms.smartflow.model.Form;
import org.openvpms.smartflow.model.Hospitalization;
import org.openvpms.smartflow.model.Medic;
import org.openvpms.smartflow.model.Patient;
import org.openvpms.smartflow.service.Hospitalizations;
import org.openvpms.ws.util.MediaTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HospitalizationService
extends FlowSheetService {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final DocumentHandlers handlers;
    private final MedicalRecordRules rules;
    private static final Logger log = LoggerFactory.getLogger(HospitalizationService.class);
    private static final String COLOUR = "colour";
    private static final String IDENTITY_ARCHETYPE = "actIdentity.smartflowsheet";

    public HospitalizationService(String url, String emrApiKey, String clinicApiKey, TimeZone timeZone, ArchetypeService service, LookupService lookups, DocumentHandlers handlers, MedicalRecordRules rules) {
        super(url, emrApiKey, clinicApiKey, timeZone, 20, log);
        this.service = service;
        this.lookups = lookups;
        this.handlers = handlers;
        this.rules = rules;
    }

    public boolean exists(PatientContext context) {
        return this.getHospitalization(context) != null;
    }

    public Hospitalization getHospitalization(final PatientContext context) {
        FlowSheetService.Call<Hospitalization, Hospitalizations> call = new FlowSheetService.Call<Hospitalization, Hospitalizations>(){

            @Override
            public Hospitalization call(Hospitalizations resource) {
                Hospitalization result = null;
                try {
                    result = resource.get(Long.toString(context.getVisitId()));
                }
                catch (NotFoundException ignore) {
                    log.debug("No hospitalization found for id=" + context.getVisitId());
                }
                return result;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetHospitalization(context.getPatient());
            }
        };
        return this.call(Hospitalizations.class, call);
    }

    public void add(final PatientContext context, int stayDuration, int departmentId, String template) {
        String reason;
        User clinician;
        final Hospitalization hospitalization = new Hospitalization();
        Patient patient = this.createPatient(context);
        hospitalization.setPatient(patient);
        hospitalization.setFileNumber(patient.getPatientId());
        hospitalization.setEstimatedDaysOfStay(stayDuration);
        hospitalization.setCaution(context.isAggressive());
        if (departmentId != -1) {
            hospitalization.setDepartmentId(departmentId);
        }
        hospitalization.setTreatmentTemplateName(template);
        hospitalization.setHospitalizationId(Long.toString(context.getVisitId()));
        hospitalization.setDateCreated(context.getVisitStartTime());
        Weight weight = context.getWeight();
        if (weight != null) {
            if (weight.getUnits() == WeightUnits.KILOGRAMS || weight.getUnits() == WeightUnits.GRAMS) {
                hospitalization.setWeight(weight.toKilograms().doubleValue());
                hospitalization.setWeightUnits("kg");
            } else if (weight.getUnits() == WeightUnits.POUNDS) {
                hospitalization.setWeight(weight.getWeight().doubleValue());
                hospitalization.setWeightUnits("lbs");
            }
        }
        if ((clinician = context.getClinician()) != null) {
            hospitalization.setDoctorName(clinician.getName());
        }
        if ((reason = this.lookups.getName((IMObject)context.getVisit(), "reason")) != null) {
            String[] diseases = new String[]{reason};
            hospitalization.setDiseases(diseases);
        }
        FlowSheetService.Call<Void, Hospitalizations> call = new FlowSheetService.Call<Void, Hospitalizations>(){

            @Override
            public Void call(Hospitalizations resource) {
                resource.add(hospitalization);
                return null;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToCreateFlowSheet(context.getPatient(), exception.getMessage());
            }
        };
        this.call(Hospitalizations.class, call);
    }

    public Anesthetics getAnesthetics(final Party patient, Act visit) {
        final String hospitalizationId = Long.toString(visit.getId());
        FlowSheetService.Call<Anesthetics, Hospitalizations> call = new FlowSheetService.Call<Anesthetics, Hospitalizations>(){

            @Override
            public Anesthetics call(Hospitalizations resource) {
                return resource.getAnesthetics(hospitalizationId);
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetAnaesthetics(patient);
            }
        };
        return this.call(Hospitalizations.class, call);
    }

    public DentalCharts getDentalCharts(final Party patient, Act visit) {
        final String hospitalizationId = Long.toString(visit.getId());
        FlowSheetService.Call<DentalCharts, Hospitalizations> call = new FlowSheetService.Call<DentalCharts, Hospitalizations>(){

            @Override
            public DentalCharts call(Hospitalizations resource) {
                return resource.getDentalCharts(hospitalizationId);
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetDentalCharts(patient);
            }
        };
        return this.call(Hospitalizations.class, call);
    }

    public List<Form> getForms(final Party patient, Act visit) {
        final String hospitalizationId = Long.toString(visit.getId());
        FlowSheetService.Call<List<Form>, Hospitalizations> call = new FlowSheetService.Call<List<Form>, Hospitalizations>(){

            @Override
            public List<Form> call(Hospitalizations resource) {
                return resource.getForms(hospitalizationId);
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetForms(patient);
            }
        };
        return this.call(Hospitalizations.class, call);
    }

    public void discharge(final Party patient, Act visit) {
        final String hospitalizationId = Long.toString(visit.getId());
        FlowSheetService.Call<Void, Hospitalizations> call = new FlowSheetService.Call<Void, Hospitalizations>(){

            @Override
            public Void call(Hospitalizations resource) {
                resource.discharge(hospitalizationId, "");
                return null;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToDischargePatient(patient, exception.getMessage());
            }
        };
        this.call(Hospitalizations.class, call);
    }

    public void saveFlowSheetReport(PatientContext context) {
        this.saveFlowSheetReport(context.getPatient(), context.getVisit(), context.getClinician());
    }

    public void saveFlowSheetReport(Party patient, Act visit, User clinician) {
        String name = FlowSheetMessages.reportFileName(FlowSheetMessages.flowSheetReportName());
        this.saveReport(name, patient, visit, clinician, Hospitalizations::getFlowSheetReport);
    }

    public void saveMedicalRecords(PatientContext context) {
        this.saveMedicalRecordsReport(context.getPatient(), context.getVisit(), context.getClinician());
    }

    public void saveMedicalRecordsReport(Party patient, Act visit, User clinician) {
        String name = FlowSheetMessages.reportFileName(FlowSheetMessages.medicalRecordsReportName());
        this.saveReport(name, patient, visit, clinician, Hospitalizations::getMedicalRecordsReport);
    }

    public void saveBillingReport(PatientContext context) {
        this.saveBillingReport(context.getPatient(), context.getVisit(), context.getClinician());
    }

    public void saveBillingReport(Party patient, Act visit, User clinician) {
        String name = FlowSheetMessages.reportFileName(FlowSheetMessages.billingReportName());
        this.saveReport(name, patient, visit, clinician, Hospitalizations::getBillingReport);
    }

    public void saveNotesReport(PatientContext context) {
        this.saveNotesReport(context.getPatient(), context.getVisit(), context.getClinician());
    }

    public void saveNotesReport(Party patient, Act visit, User clinician) {
        String name = FlowSheetMessages.reportFileName(FlowSheetMessages.notesReportName());
        this.saveReport(name, patient, visit, clinician, Hospitalizations::getNotesReport);
    }

    public void saveAnestheticsReports(Party patient, Act visit) {
        Anesthetics anesthetics = this.getAnesthetics(patient, visit);
        List<Anesthetic> list = anesthetics.getAnesthetics();
        if (list != null) {
            for (Anesthetic anesthetic : list) {
                this.saveAnestheticReports(patient, visit, anesthetic);
            }
        }
    }

    public void saveAnestheticReports(PatientContext context, Anesthetic anesthetic) {
        this.saveAnestheticReports(context.getPatient(), context.getVisit(), anesthetic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAnestheticReports(Party patient, Act visit, Anesthetic anesthetic) {
        try (javax.ws.rs.client.Client client = null;){
            boolean haveRecordsReport;
            client = this.getClient();
            String identity = anesthetic.getSurgeryGuid();
            String reportPath = anesthetic.getReportPath();
            String recordsReportPath = anesthetic.getRecordsReportPath();
            boolean haveReport = !StringUtils.isEmpty((CharSequence)reportPath);
            boolean bl = haveRecordsReport = !StringUtils.isEmpty((CharSequence)recordsReportPath);
            if (haveReport || haveRecordsReport) {
                String name;
                User clinician = this.getClinician(anesthetic);
                if (haveReport) {
                    name = FlowSheetMessages.reportFileName(FlowSheetMessages.anaestheticReportName());
                    this.saveReport(name, identity, patient, visit, clinician, reportPath, client);
                }
                if (haveRecordsReport) {
                    name = FlowSheetMessages.reportFileName(FlowSheetMessages.anaestheticRecordsReportName());
                    this.saveReport(name, identity, patient, visit, clinician, recordsReportPath, client);
                }
            }
        }
    }

    public void saveDentalReports(Party patient, Act visit, User clinician) {
        DentalCharts charts = this.getDentalCharts(patient, visit);
        List<DentalChart> list = charts.getDentalCharts();
        if (list != null) {
            for (DentalChart chart : list) {
                this.saveDentalReport(patient, visit, clinician, chart);
            }
        }
    }

    public void saveDentalReport(PatientContext context, DentalChart chart) {
        this.saveDentalReport(context.getPatient(), context.getVisit(), context.getClinician(), chart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDentalReport(Party patient, Act visit, User clinician, DentalChart chart) {
        String reportPath = chart.getReportPath();
        if (!StringUtils.isEmpty((CharSequence)reportPath)) {
            try (javax.ws.rs.client.Client client = null;){
                client = this.getClient();
                String identity = chart.getDentalChartGuid();
                String name = FlowSheetMessages.reportFileName(FlowSheetMessages.dentalReportName());
                this.saveReport(name, identity, patient, visit, clinician, reportPath, client);
            }
        }
    }

    public void saveFormsReports(Party patient, Act visit, User clinician) {
        for (Form form : this.getForms(patient, visit)) {
            if (form.isDeleted() || !form.isFinalized()) continue;
            this.saveFormReport(patient, visit, clinician, form);
        }
    }

    public void saveFormReport(PatientContext context, Form form) {
        this.saveFormReport(context.getPatient(), context.getVisit(), context.getClinician(), form);
    }

    public void saveFormReport(Party patient, Act visit, User clinician, Form form) {
        ReportRetriever reportRetriever = (service, id) -> service.getFormReport(id, form.getFormGuid());
        this.saveReport(form.getTitle(), patient, visit, clinician, reportRetriever);
    }

    private void saveReport(String name, String identity, Party patient, Act visit, User clinician, String path, javax.ws.rs.client.Client client) {
        try {
            WebTarget target = client.target(path);
            Response response = target.request().headers(this.getHeaders()).get();
            this.saveReport(response, identity, name, patient, visit, clinician);
        }
        catch (FlowSheetException exception) {
            throw exception;
        }
        catch (NotAuthorizedException exception) {
            this.notAuthorised(exception);
        }
        catch (Exception exception) {
            this.checkSSL(exception);
            if (this.isAccessToDocumentDenied(exception)) {
                throw new AccessToDocumentDeniedException(FlowSheetMessages.accessToDocumentDenied(name, exception.getMessage()));
            }
            throw new FlowSheetException(FlowSheetMessages.failedToDownloadPDF(patient, name), exception);
        }
    }

    private void saveReport(final String name, final Party patient, final Act visit, final User clinician, final ReportRetriever retriever) {
        FlowSheetService.Call<Void, Hospitalizations> call = new FlowSheetService.Call<Void, Hospitalizations>(){

            @Override
            public Void call(Hospitalizations resource) throws Exception {
                String id = Long.toString(visit.getId());
                Response response = retriever.getResponse(resource, id);
                HospitalizationService.this.saveReport(response, null, name, patient, visit, clinician);
                return null;
            }

            @Override
            public FlowSheetException failed(Exception exception) {
                FlowSheetException result = HospitalizationService.this.isAccessToDocumentDenied(exception) ? new AccessToDocumentDeniedException(FlowSheetMessages.accessToDocumentDenied(name, exception.getMessage())) : super.failed(exception);
                return result;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToDownloadPDF(patient, name);
            }
        };
        this.call(Hospitalizations.class, call);
    }

    private void saveReport(Response response, String identity, String name, Party patient, Act visit, User clinician) throws IOException {
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL && response.hasEntity() && MediaTypes.isA((MediaType)response.getMediaType(), (MediaType[])new MediaType[]{MediaTypes.APPLICATION_PDF_TYPE, MediaType.APPLICATION_OCTET_STREAM_TYPE})) {
            try (InputStream stream = (InputStream)response.getEntity();){
                String fileName = name + ".pdf";
                ArrayList<Act> objects = new ArrayList<Act>();
                DocumentAct act = this.getAttachment(fileName, identity, patient, visit, clinician);
                DocumentHandler documentHandler = this.handlers.find(fileName, "application/pdf");
                DocumentRules rules = new DocumentRules(this.service);
                Document document = documentHandler.create(fileName, stream, "application/pdf", -1);
                if (act.isNew()) {
                    IMObjectBean visitBean = this.service.getBean((IMObject)visit);
                    ActRelationship relationship = (ActRelationship)visitBean.addTarget("items", (IMObject)act);
                    act.addActRelationship(relationship);
                    objects.add(visit);
                }
                objects.addAll(rules.addDocument(act, (org.openvpms.component.model.document.Document)document));
                this.service.save(objects);
            }
        } else {
            log.error("Failed to get " + name + " for hospitalizationId=" + visit.getId() + ", status=" + response.getStatus() + ", mediaType=" + response.getMediaType());
            throw new FlowSheetException(FlowSheetMessages.failedToDownloadPDF(patient, name));
        }
    }

    private DocumentAct getAttachment(String name, String identity, Party patient, Act visit, User clinician) {
        DocumentAct act = (identity = StringUtils.trimToNull((String)identity)) != null ? this.rules.getAttachment(name, visit, IDENTITY_ARCHETYPE, identity) : this.rules.getAttachment(name, visit);
        if (act == null) {
            act = (DocumentAct)this.service.create("act.patientDocumentAttachment", DocumentAct.class);
            if (identity != null) {
                ActIdentity id = (ActIdentity)this.service.create(IDENTITY_ARCHETYPE, ActIdentity.class);
                id.setIdentity(identity);
                act.addIdentity(id);
            }
            IMObjectBean bean = this.service.getBean((IMObject)act);
            bean.setTarget("patient", (IMObject)patient);
            bean.setTarget("clinician", (IMObject)clinician);
        }
        return act;
    }

    private boolean isAccessToDocumentDenied(Throwable exception) {
        return exception instanceof WebApplicationException && ((WebApplicationException)exception).getResponse().getStatus() == 465;
    }

    private Patient createPatient(PatientContext context) {
        Party owner;
        Patient result = new Patient();
        IMObjectBean bean = this.service.getBean((IMObject)context.getPatient());
        result.setPatientId(Long.toString(context.getPatientId()));
        result.setName(context.getPatientFirstName());
        Date dateOfBirth = context.getDateOfBirth();
        if (dateOfBirth != null) {
            dateOfBirth = this.getUTCDate(dateOfBirth);
        }
        result.setBirthday(dateOfBirth);
        result.setSpecies(context.getSpeciesName());
        result.setBreed(context.getBreedName());
        result.setColor(this.getColour(bean));
        result.setSex(this.getSex(context));
        StringBuilder criticalNotes = new StringBuilder();
        for (Act alert : context.getAllergies()) {
            String reason = alert.getReason();
            if (StringUtils.isEmpty((CharSequence)reason)) continue;
            if (criticalNotes.length() != 0) {
                criticalNotes.append('\n');
            }
            criticalNotes.append(reason);
        }
        if (criticalNotes.length() != 0) {
            result.setCriticalNotes(criticalNotes.toString());
        }
        if ((owner = context.getCustomer()) != null) {
            result.setOwner(this.createClient(context));
        }
        return result;
    }

    private Date getUTCDate(Date date) {
        GregorianCalendar utc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        GregorianCalendar local = new GregorianCalendar();
        local.setTime(date);
        utc.set(1, local.get(1));
        utc.set(2, local.get(2));
        utc.set(5, local.get(5));
        utc.set(11, 0);
        utc.set(12, 0);
        utc.set(13, 0);
        utc.set(14, 0);
        return utc.getTime();
    }

    private Client createClient(PatientContext context) {
        Client result = new Client();
        IMObjectBean bean = this.service.getBean((IMObject)context.getCustomer());
        result.setOwnerId(Long.toString(context.getCustomer().getId()));
        Lookup title = bean.getLookup("title");
        if (title != null) {
            result.setTitle(title.getName());
        }
        result.setNameFirst(bean.getString("firstName"));
        result.setNameLast(bean.getString("lastName"));
        result.setHomePhone(context.getHomePhone());
        result.setWorkPhone(context.getWorkPhone());
        result.setCellPhone(context.getMobilePhone());
        result.setFax(context.getFax());
        result.setEmail(context.getEmail());
        Contact contact = context.getAddress();
        if (contact != null) {
            IMObjectBean contactBean = this.service.getBean((IMObject)contact);
            Address address = new Address();
            address.setLine1(contactBean.getString("address"));
            Lookup suburb = contactBean.getLookup("suburb");
            if (suburb != null) {
                address.setCity(suburb.getName());
            }
            address.setZip(contactBean.getString("postcode"));
            Lookup state = contactBean.getLookup("state");
            if (state != null) {
                address.setState(state.getName());
            }
            result.setAddress(address);
        }
        return result;
    }

    private User getClinician(Anesthetic anesthetic) {
        Medic surgeon = anesthetic.getSurgeon();
        return surgeon != null ? (User)SmartFlowSheetHelper.getObject(surgeon.getMedicId(), "security.user", this.service) : null;
    }

    private String getColour(IMObjectBean bean) {
        NodeDescriptor node = bean.getNode(COLOUR);
        return node.isLookup() ? this.lookups.getName(bean.getObject(), COLOUR) : bean.getString(COLOUR);
    }

    private String getSex(PatientContext context) {
        String sex = context.getPatientSex();
        boolean desexed = context.isDesexed();
        String result = "FEMALE".equals(sex) ? (desexed ? "FS" : "F") : (desexed ? "MN" : "M");
        return result;
    }

    private static interface ReportRetriever {
        public Response getResponse(Hospitalizations var1, String var2);
    }
}

