/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.client;

import java.util.Collections;
import java.util.TimeZone;
import javax.net.ssl.SSLHandshakeException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.openvpms.component.i18n.Message;
import org.openvpms.smartflow.client.FlowSheetException;
import org.openvpms.smartflow.i18n.FlowSheetMessages;
import org.openvpms.smartflow.model.Error;
import org.openvpms.ws.util.ErrorResponseFilter;
import org.openvpms.ws.util.ObjectMapperContextResolver;
import org.openvpms.ws.util.SLF4JLoggingFeature;
import org.slf4j.Logger;

public abstract class FlowSheetService {
    protected static final Form EMPTY_FORM = new Form();
    protected static final int DEFAULT_TIMEOUT = 20;
    protected static final int LONG_TIMEOUT = 120;
    private final String url;
    private final String emrApiKey;
    private final String clinicApiKey;
    private final TimeZone timeZone;
    private final int timeoutMs;
    private final Logger log;

    public FlowSheetService(String url, String emrApiKey, String clinicApiKey, TimeZone timeZone, int timeout, Logger log) {
        this.url = url;
        this.emrApiKey = emrApiKey;
        this.clinicApiKey = clinicApiKey;
        this.timeZone = timeZone;
        this.timeoutMs = timeout * 1000;
        this.log = log;
    }

    protected void notAuthorised(NotAuthorizedException exception) {
        this.log.error(exception.getMessage(), (Throwable)exception);
        throw new FlowSheetException(FlowSheetMessages.notAuthorised());
    }

    protected void checkSSL(Throwable exception) {
        if (exception.getCause() instanceof SSLHandshakeException) {
            this.log.error(exception.getMessage(), exception);
            throw new FlowSheetException(FlowSheetMessages.cannotConnectUsingSSL(this.url));
        }
    }

    protected Client getClient() {
        if (this.timeZone.getID().startsWith("GMT")) {
            throw new FlowSheetException(FlowSheetMessages.unsupportedTimeZone(this.timeZone.getID()));
        }
        ObjectMapperContextResolver resolver = new ObjectMapperContextResolver(this.timeZone);
        ClientConfig config = new ClientConfig().property("jersey.config.client.connectTimeout", (Object)this.timeoutMs).property("jersey.config.client.readTimeout", (Object)this.timeoutMs).register((Object)resolver).register(JacksonFeature.class).register((Object)new ErrorResponseFilter(resolver.getContext(Object.class), Error.class)).register((Object)new SLF4JLoggingFeature(this.log, new String[]{"clinicApiKey"}));
        return ClientBuilder.newClient((Configuration)config);
    }

    protected <T> T getResource(Class<T> type, Client client) {
        WebTarget target = this.getWebTarget(client);
        return (T)WebResourceFactory.newResource(type, (WebTarget)target, (boolean)false, this.getHeaders(), Collections.emptyList(), (Form)EMPTY_FORM);
    }

    protected WebTarget getWebTarget(Client client) {
        return client.target(this.url);
    }

    protected MultivaluedMap<String, Object> getHeaders() {
        MultivaluedHashMap header = new MultivaluedHashMap();
        header.add((Object)"emrApiKey", (Object)this.emrApiKey);
        header.add((Object)"clinicApiKey", (Object)this.clinicApiKey);
        header.add((Object)"timezoneName", (Object)this.timeZone.getID());
        return header;
    }

    protected <T, R> T call(Class<R> resource, Call<T, R> call) {
        T result = null;
        try (Client client = this.getClient();){
            R instance = this.getResource(resource, client);
            result = call.call(instance);
        }
        return result;
    }

    protected abstract class Call<T, R> {
        protected Call() {
        }

        public abstract T call(R var1) throws Exception;

        public abstract Message getMessage(Exception var1);

        public FlowSheetException failed(Exception exception) {
            Message message = this.getMessage(exception);
            return new FlowSheetException(message, exception);
        }
    }
}

