/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.order.CustomerOrder;
import org.openvpms.archetype.rules.finance.order.CustomerPharmacyOrder;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.hl7.impl.HL7MessageHelper;
import org.openvpms.smartflow.event.impl.EventProcessor;
import org.openvpms.smartflow.event.impl.SmartFlowSheetHelper;
import org.openvpms.smartflow.model.Medic;
import org.openvpms.smartflow.model.Treatment;
import org.openvpms.smartflow.model.Treatments;
import org.openvpms.smartflow.model.event.TreatmentEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreatmentEventProcessor
extends EventProcessor<TreatmentEvent> {
    private final Party location;
    private final LookupService lookups;
    private final PatientRules rules;
    private static final String[] PRODUCT_ARCHETYPES = new String[]{"product.medication", "product.merchandise", "product.service"};
    private static final Logger log = LoggerFactory.getLogger(TreatmentEventProcessor.class);

    public TreatmentEventProcessor(Party location, IArchetypeService service, LookupService lookups, PatientRules rules) {
        super(service);
        this.location = location;
        this.lookups = lookups;
        this.rules = rules;
    }

    @Override
    public void process(TreatmentEvent event) {
        Treatments list = (Treatments)event.getObject();
        if (list != null && list.getTreatments() != null) {
            ArrayList<Treatment> treatments = new ArrayList<Treatment>(list.getTreatments());
            treatments.sort((o1, o2) -> {
                Comparator comparator = ComparatorUtils.nullLowComparator(null);
                int result = comparator.compare(o1.getTreatmentGuid(), o2.getTreatmentGuid());
                if (result == 0) {
                    Status status1 = Status.fromString(o1.getStatus());
                    Status status2 = Status.fromString(o2.getStatus());
                    result = status1.compareTo(status2);
                }
                return result;
            });
            for (Treatment treatment : treatments) {
                this.treated(treatment);
            }
        }
    }

    protected void treated(Treatment treatment) {
        if (log.isDebugEnabled()) {
            log.debug("treatment=" + treatment.getTreatmentGuid() + ", inventoryId=" + treatment.getInventoryId() + ", name=" + treatment.getName() + ", quantity=" + treatment.getQty() + ", status=" + treatment.getStatus() + ", billed=" + treatment.getBilled());
        }
        Act visit = this.getVisit(treatment.getHospitalizationId());
        Party patient = null;
        Party customer = null;
        if (visit != null && (patient = this.getPatient(visit)) != null) {
            customer = this.rules.getOwner(patient);
        }
        Product product = this.getProduct(treatment);
        IMObjectReference clinician = this.getClinician(treatment);
        if ("added".equals(treatment.getStatus())) {
            if (treatment.getBilled()) {
                this.treatmentAdded(treatment, visit, patient, customer, product, null, clinician);
            }
        } else if ("changed".equals(treatment.getStatus())) {
            this.treatmentChanged(treatment, visit, patient, customer, product, clinician);
        } else if ("removed".equals(treatment.getStatus())) {
            this.treatmentRemoved(treatment, visit, patient, customer, product, clinician);
        }
    }

    protected List<CustomerPharmacyOrder> getOrders(Treatment treatment) {
        return TreatmentEventProcessor.getOrders(treatment.getTreatmentGuid(), this.getService());
    }

    protected static List<CustomerPharmacyOrder> getOrders(String treatmentGuid, IArchetypeService service) {
        ArrayList<CustomerPharmacyOrder> result = new ArrayList<CustomerPharmacyOrder>();
        String[] archetypes = new String[]{"act.customerOrderPharmacy", "act.customerReturnPharmacy"};
        ArchetypeQuery query = new ArchetypeQuery(archetypes, false, false);
        query.add((IConstraint)Constraints.join((String)"identities", (BaseArchetypeConstraint)Constraints.shortName((String)"actIdentity.smartflowsheet")).add((IConstraint)Constraints.eq((String)"identity", (Object)treatmentGuid)));
        query.add((IConstraint)Constraints.sort((String)"startTime"));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(-1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            result.add(new CustomerPharmacyOrder((Act)iterator.next(), service));
        }
        return result;
    }

    private void treatmentAdded(Treatment treatment, Act visit, Party patient, Party customer, Product product, String note, IMObjectReference clinician) {
        BigDecimal quantity = this.getQuantity(treatment);
        if (!MathRules.isZero((BigDecimal)quantity)) {
            this.createOrder(treatment, visit, patient, customer, product, quantity, note, clinician);
        }
    }

    private void treatmentChanged(Treatment treatment, Act visit, Party patient, Party customer, Product product, IMObjectReference clinician) {
        List<CustomerPharmacyOrder> orders = this.getOrders(treatment);
        if (orders.isEmpty()) {
            if (treatment.getBilled()) {
                this.treatmentAdded(treatment, visit, patient, customer, product, "NOTE: Treatment changed, but original order not found.", clinician);
            }
        } else if (treatment.getBilled()) {
            BigDecimal quantity = this.getQuantity(treatment);
            this.update(orders, treatment, visit, patient, customer, product, quantity, clinician);
        } else {
            this.update(orders, treatment, visit, patient, customer, product, BigDecimal.ZERO, clinician);
        }
    }

    private Product getProduct(List<CustomerPharmacyOrder> orders) {
        Product result = null;
        CustomerPharmacyOrder order = orders.get(orders.size() - 1);
        for (Act act : order.getActs()) {
            Product product;
            IMObjectBean bean = this.getService().getBean((IMObject)act);
            if (!bean.hasNode("product") || (product = (Product)bean.getTarget("product", Product.class)) == null) continue;
            result = product;
            break;
        }
        return result;
    }

    private void treatmentRemoved(Treatment treatment, Act visit, Party patient, Party customer, Product product, IMObjectReference clinician) {
        List<CustomerPharmacyOrder> orders = this.getOrders(treatment);
        if (orders.isEmpty()) {
            if (treatment.getBilled()) {
                log.warn("Treatment=" + treatment.getTreatmentGuid() + " removed, but no order found");
            }
        } else {
            this.update(orders, treatment, visit, patient, customer, product, BigDecimal.ZERO, clinician);
        }
    }

    private void update(List<CustomerPharmacyOrder> orders, Treatment treatment, Act visit, Party patient, Party customer, Product product, BigDecimal newQuantity, IMObjectReference clinician) {
        if (product == null) {
            product = this.getProduct(orders);
        }
        ChargedState state = new ChargedState(orders, product);
        BigDecimal postedQuantity = state.getPostedQuantity();
        CustomerPharmacyOrder inProgress = state.getInProgress();
        if (postedQuantity.compareTo(newQuantity) == 0) {
            if (inProgress != null) {
                inProgress.remove();
            }
        } else if (postedQuantity.compareTo(newQuantity) < 0) {
            BigDecimal diff = newQuantity.subtract(postedQuantity);
            if (inProgress == null) {
                this.createOrder(treatment, visit, patient, customer, product, diff, null, clinician);
            } else if (inProgress.hasOrder()) {
                IMObjectBean item = inProgress.getItem(product);
                if (item == null) {
                    item = inProgress.createOrderItem();
                }
                this.populateItem(inProgress.getOrder(), item, treatment, product, diff, (Reference)clinician);
                inProgress.save();
            } else {
                inProgress.remove();
                this.createOrder(treatment, visit, patient, customer, product, diff, null, clinician);
            }
        } else {
            BigDecimal diff = postedQuantity.subtract(newQuantity);
            if (inProgress == null) {
                this.createReturn(treatment, visit, patient, customer, product, diff, null, clinician);
            } else if (inProgress.hasOrder()) {
                inProgress.remove();
                this.createReturn(treatment, visit, patient, customer, product, diff, null, clinician);
            } else {
                IMObjectBean item = inProgress.getItem(product);
                if (item == null) {
                    item = inProgress.createReturnItem();
                }
                this.populateItem(inProgress.getReturn(), item, treatment, product, diff, (Reference)clinician);
                inProgress.save();
            }
        }
    }

    private void createOrder(Treatment treatment, Act visit, Party patient, Party customer, Product product, BigDecimal quantity, String note, IMObjectReference clinician) {
        IArchetypeService service = this.getService();
        CustomerPharmacyOrder order = new CustomerPharmacyOrder(patient, customer, null, this.location != null ? this.location.getObjectReference() : null, service);
        this.populate(order.getOrder(), treatment, visit, patient, customer, note, clinician);
        this.populateItem(order.getOrder(), order.createOrderItem(), treatment, product, quantity, (Reference)clinician);
        service.save((Collection)order.getActs());
    }

    private void createReturn(Treatment treatment, Act visit, Party patient, Party customer, Product product, BigDecimal quantity, String note, IMObjectReference clinician) {
        IArchetypeService service = this.getService();
        CustomerPharmacyOrder orderReturn = new CustomerPharmacyOrder(patient, customer, null, this.location != null ? this.location.getObjectReference() : null, service);
        this.populate(orderReturn.getReturn(), treatment, visit, patient, customer, note, clinician);
        this.populateItem(orderReturn.getReturn(), orderReturn.createReturnItem(), treatment, product, quantity, (Reference)clinician);
        service.save((Collection)orderReturn.getActs());
    }

    private void populate(IMObjectBean act, Treatment treatment, Act visit, Party patient, Party customer, String note, IMObjectReference clinician) {
        ActIdentity identity = this.createIdentity(treatment.getTreatmentGuid());
        ((Act)act.getObject(Act.class)).addIdentity(identity);
        if (!StringUtils.isEmpty((CharSequence)note)) {
            CustomerOrder.addNote((IMObjectBean)act, (String)note);
        }
        if (!StringUtils.isEmpty((CharSequence)treatment.getValue())) {
            CustomerOrder.addNote((IMObjectBean)act, (String)treatment.getValue());
        }
        if (visit == null) {
            CustomerOrder.addNote((IMObjectBean)act, (String)("Unknown visit, Id='" + treatment.getHospitalizationId() + "'. The customer and patient cannot be determined"));
        } else if (patient == null) {
            CustomerOrder.addNote((IMObjectBean)act, (String)"Cannot determine patient for visit");
        } else if (customer == null) {
            CustomerOrder.addNote((IMObjectBean)act, (String)"Cannot determine customer for patient");
        }
        if (clinician != null) {
            act.setTarget("clinician", (Reference)clinician);
        }
    }

    private void populateItem(IMObjectBean order, IMObjectBean item, Treatment treatment, Product product, BigDecimal quantity, Reference clinician) {
        item.setValue("quantity", (Object)quantity);
        if (product != null) {
            item.setTarget("product", (IMObject)product);
            String units = treatment.getUnits();
            IMObjectBean productBean = this.getService().getBean((IMObject)product);
            String sellingUnits = productBean.getString("sellingUnits");
            if (!StringUtils.isEmpty((CharSequence)units) && !StringUtils.isEmpty((CharSequence)sellingUnits)) {
                boolean match = true;
                if (!units.equalsIgnoreCase(sellingUnits)) {
                    Lookup uom = this.lookups.getLookup("lookup.uom", sellingUnits);
                    if (uom != null && !StringUtils.isEmpty((CharSequence)uom.getName())) {
                        if (!units.equalsIgnoreCase(uom.getName())) {
                            sellingUnits = uom.getName();
                            match = false;
                        }
                    } else {
                        match = false;
                    }
                }
                if (!match) {
                    CustomerOrder.addNote((IMObjectBean)order, (String)("Dispensing units ('" + units + "') do not match selling units ('" + sellingUnits + "')"));
                }
            }
        } else {
            CustomerOrder.addNote((IMObjectBean)order, (String)("Unknown Treatment, Id='" + treatment.getInventoryId() + "', name='" + treatment.getName() + "'"));
        }
        if (clinician != null) {
            item.setTarget("clinician", clinician);
        }
    }

    private Product getProduct(Treatment treatment) {
        Product result = null;
        long id = SmartFlowSheetHelper.getId(treatment.getInventoryId());
        if (id != -1L) {
            ArchetypeQuery query = new ArchetypeQuery(PRODUCT_ARCHETYPES, true, true);
            query.add((IConstraint)Constraints.eq((String)"id", (Object)id));
            IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.getService(), (IArchetypeQuery)query);
            result = iterator.hasNext() ? (Product)iterator.next() : null;
        }
        return result;
    }

    private BigDecimal getQuantity(Treatment treatment) {
        BigDecimal qty = treatment.getQty();
        qty = qty == null ? BigDecimal.ZERO : MathRules.round((BigDecimal)qty, (int)3);
        return qty;
    }

    private IMObjectReference getClinician(Treatment treatment) {
        long id;
        IMObjectReference result = null;
        Medic doctor = treatment.getDoctor();
        if (doctor != null && (id = HL7MessageHelper.getId((String)doctor.getMedicId())) != -1L) {
            ArchetypeQuery query = new ArchetypeQuery("security.user");
            query.getArchetypeConstraint().setAlias("user");
            query.add((IConstraint)new ObjectRefSelectConstraint("user"));
            query.add((IConstraint)Constraints.join((String)"classifications").add((IConstraint)Constraints.eq((String)"code", (Object)"CLINICIAN")));
            query.add((IConstraint)Constraints.eq((String)"id", (Object)id));
            ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.getService(), (IArchetypeQuery)query);
            if (iterator.hasNext()) {
                ObjectSet set = (ObjectSet)iterator.next();
                result = set.getReference("user.reference");
            }
            if (result == null) {
                log.warn("No clinician found for id=" + doctor.getMedicId() + ", name=" + doctor.getName());
            }
        }
        return result;
    }

    private static enum Status {
        removed,
        added,
        changed,
        not_changed,
        unknown;


        public static Status fromString(String status) {
            Status result;
            if (status != null) {
                try {
                    result = Status.valueOf(status);
                }
                catch (IllegalArgumentException ignore) {
                    result = unknown;
                }
            } else {
                result = unknown;
            }
            return result;
        }
    }

    private class ChargedState {
        private BigDecimal quantity = BigDecimal.ZERO;
        private CustomerPharmacyOrder inProgress;

        ChargedState(List<CustomerPharmacyOrder> orders, Product product) {
            for (CustomerPharmacyOrder order : orders) {
                boolean isOrder = order.hasOrder();
                IMObjectBean bean = isOrder ? order.getOrder() : order.getReturn();
                String status = bean.getString("status");
                IMObjectBean item = order.getItem(product);
                BigDecimal itemQty = BigDecimal.ZERO;
                if (item != null) {
                    itemQty = item.getBigDecimal("quantity", BigDecimal.ZERO);
                    if (!isOrder) {
                        itemQty = itemQty.negate();
                    }
                }
                if ("IN_PROGRESS".equals(status)) {
                    this.inProgress = order;
                    continue;
                }
                this.quantity = this.quantity.add(itemQty);
            }
        }

        public BigDecimal getPostedQuantity() {
            return this.quantity;
        }

        public CustomerPharmacyOrder getInProgress() {
            return this.inProgress;
        }
    }
}

