/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.client;

import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.smartflow.client.FlowSheetException;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.smartflow.client.InventoryService;
import org.openvpms.smartflow.client.ReferenceDataService;
import org.openvpms.smartflow.i18n.FlowSheetMessages;

public class FlowSheetServiceFactory {
    private final String url;
    private final String emrApiKey;
    private final IArchetypeService service;
    private final LookupService lookups;
    private final DocumentHandlers handlers;
    private final MedicalRecordRules rules;
    private final PasswordEncryptor encryptor;

    public FlowSheetServiceFactory(String url, String emrApiKey, IArchetypeService service, LookupService lookups, DocumentHandlers handlers, MedicalRecordRules rules, PasswordEncryptor encryptor) {
        this.url = url;
        this.emrApiKey = emrApiKey;
        this.service = service;
        this.lookups = lookups;
        this.handlers = handlers;
        this.rules = rules;
        this.encryptor = encryptor;
    }

    public boolean isSmartFlowSheetEnabled(Party location) {
        return this.getClinicAPIKey(location) != null;
    }

    public String getClinicAPIKey(Party location) {
        IMObjectBean bean;
        String result = null;
        if (location != null && (result = StringUtils.trimToNull((String)(bean = this.service.getBean((IMObject)location)).getString("smartFlowSheetKey"))) != null) {
            try {
                result = this.encryptor.decrypt(result);
            }
            catch (Throwable exception) {
                throw new FlowSheetException(FlowSheetMessages.failedToDecryptAPIKey(location), exception);
            }
        }
        return result;
    }

    public HospitalizationService getHospitalizationService(Party location) {
        String apiKey = this.getRequiredClinicAPIKey(location);
        return this.getHospitalizationService(apiKey);
    }

    public HospitalizationService getHospitalizationService(String apiKey) {
        return new HospitalizationService(this.url, this.emrApiKey, apiKey, TimeZone.getDefault(), (ArchetypeService)this.service, this.lookups, this.handlers, this.rules);
    }

    public ReferenceDataService getReferenceDataService(Party location) {
        String clinicKey = this.getRequiredClinicAPIKey(location);
        return new ReferenceDataService(this.url, this.emrApiKey, clinicKey, TimeZone.getDefault(), location, this.service);
    }

    public InventoryService getInventoryService(Party location) {
        String clinicKey = this.getRequiredClinicAPIKey(location);
        return new InventoryService(this.url, this.emrApiKey, clinicKey, TimeZone.getDefault(), this.service, this.lookups);
    }

    protected String getRequiredClinicAPIKey(Party location) {
        String clinicKey = this.getClinicAPIKey(location);
        if (clinicKey == null) {
            throw new FlowSheetException(FlowSheetMessages.notConfigured(location));
        }
        return clinicKey;
    }
}

