/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.event.EventStatus;
import org.openvpms.smartflow.event.impl.QueueDispatcher;
import org.openvpms.smartflow.event.impl.QueueDispatcherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueueDispatchers {
    private final QueueDispatcherFactory factory;
    private final Map<String, Set<Party>> locationsByKey = new HashMap<String, Set<Party>>();
    private final Map<Party, String> keysByLocation = new HashMap<Party, String>();
    private final Map<String, QueueDispatcher> dispatchers = new HashMap<String, QueueDispatcher>();
    private final ScheduledExecutorService executorService;
    private volatile boolean started;
    private volatile boolean destroyed;
    private int startDelay = 60;
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("SFS Queue Start").setDaemon(true).build();
    private static final Logger log = LoggerFactory.getLogger(QueueDispatchers.class);

    public QueueDispatchers(QueueDispatcherFactory factory) {
        this.factory = factory;
        this.executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public synchronized List<QueueDispatcher> getDispatchers() {
        return new ArrayList<QueueDispatcher>(this.dispatchers.values());
    }

    public synchronized QueueDispatcher add(Party location) {
        String newKey;
        QueueDispatcher dispatcher = null;
        String existingKey = this.keysByLocation.get(location);
        try {
            newKey = location.isActive() ? this.factory.getClinicAPIKey(location) : null;
        }
        catch (Throwable exception) {
            newKey = null;
            log.error(exception.getMessage(), exception);
        }
        if (!Objects.equals(existingKey, newKey)) {
            if (existingKey == null) {
                if (!StringUtils.isEmpty((CharSequence)newKey)) {
                    dispatcher = this.addKey(newKey, location);
                }
            } else {
                this.removeKey(existingKey, location);
                if (!StringUtils.isEmpty((CharSequence)newKey)) {
                    dispatcher = this.addKey(newKey, location);
                }
            }
        }
        return dispatcher;
    }

    public synchronized void remove(Party location) {
        String existingKey = this.keysByLocation.get(location);
        if (existingKey != null) {
            this.removeKey(existingKey, location);
        }
    }

    public synchronized EventStatus getStatus(Party location) {
        QueueDispatcher dispatcher = this.getQueueDispatcher(location);
        return dispatcher != null ? dispatcher.getStatus() : new EventStatus(null, null, null);
    }

    public void start() {
        if (!this.started && !this.destroyed) {
            this.started = true;
            for (QueueDispatcher dispatcher : this.getDispatchers()) {
                this.start(dispatcher);
            }
        }
    }

    public void destroy() {
        if (!this.destroyed) {
            this.started = false;
            this.destroyed = true;
            try {
                for (QueueDispatcher dispatcher : this.getDispatchers()) {
                    dispatcher.destroy();
                }
            }
            finally {
                this.executorService.shutdown();
                try {
                    this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (Throwable exception) {
                    log.error("Error waiting for threads to terminate: " + exception.getMessage(), exception);
                }
            }
        }
    }

    protected void setStartDelay(int seconds) {
        this.startDelay = seconds;
    }

    private QueueDispatcher getQueueDispatcher(Party location) {
        String key = this.keysByLocation.get(location);
        return key != null ? this.dispatchers.get(key) : null;
    }

    private QueueDispatcher addKey(String key, Party location) {
        QueueDispatcher dispatcher = null;
        try {
            Set locations = this.locationsByKey.computeIfAbsent(key, k -> new HashSet());
            if (locations.isEmpty()) {
                dispatcher = this.addDispatcher(key, location);
            }
            if (!locations.contains(location)) {
                if (dispatcher == null) {
                    StringBuilder names = new StringBuilder();
                    for (Party party : locations) {
                        if (names.length() != 0) {
                            names.append(", ");
                        }
                        names.append('\'').append(party.getName()).append('\'');
                    }
                    log.error("Practice location='" + location.getName() + "' shares a Smart Flow Sheet Clinic API Key with: " + names + ".\nThe location associated with any treatments is non-deterministic");
                }
                locations.add(location);
            }
            this.keysByLocation.put(location, key);
        }
        catch (Throwable exception) {
            log.error("Failed to initialise Smart Flow Sheet queue for location=" + location.getName(), exception);
        }
        return dispatcher;
    }

    private QueueDispatcher addDispatcher(String key, Party location) {
        QueueDispatcher dispatcher = this.factory.createQueueDispatcher(location);
        this.dispatchers.put(key, dispatcher);
        this.start(dispatcher);
        return dispatcher;
    }

    private void start(QueueDispatcher dispatcher) {
        if (this.started && !dispatcher.isDestroyed() && !dispatcher.start() && !dispatcher.isDestroyed()) {
            this.scheduleStart(dispatcher);
        }
    }

    private void scheduleStart(QueueDispatcher dispatcher) {
        log.info("Scheduling start of Azure Service Bus Queue for " + dispatcher.getLocation().getName() + " in " + this.startDelay + "s");
        this.executorService.schedule(() -> this.start(dispatcher), (long)this.startDelay, TimeUnit.SECONDS);
    }

    private void removeKey(String key, Party location) {
        QueueDispatcher dispatcher;
        boolean reset = false;
        Set<Party> locations = this.locationsByKey.get(key);
        if (locations != null && locations.remove(location) && locations.isEmpty()) {
            reset = true;
        }
        this.keysByLocation.remove(location);
        if (reset) {
            QueueDispatcher dispatcher2 = this.dispatchers.remove(key);
            if (dispatcher2 != null) {
                dispatcher2.stop();
            }
        } else if (locations != null && !locations.isEmpty() && (dispatcher = this.dispatchers.get(key)) != null && Objects.equals(dispatcher.getLocation(), location)) {
            dispatcher.stop();
            Party nextLocation = this.getLocation(locations);
            this.addDispatcher(key, nextLocation);
        }
    }

    private Party getLocation(Set<Party> locations) {
        ArrayList<Party> list = new ArrayList<Party>(locations);
        if (list.size() > 1) {
            list.sort(Comparator.comparingLong(IMObject::getId));
        }
        return (Party)list.get(0);
    }
}

