/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.smartflow.event.impl.EventProcessor;
import org.openvpms.smartflow.event.impl.FlowSheetConfig;
import org.openvpms.smartflow.event.impl.FlowSheetConfigService;
import org.openvpms.smartflow.i18n.FlowSheetMessages;
import org.openvpms.smartflow.model.Note;
import org.openvpms.smartflow.model.Notes;
import org.openvpms.smartflow.model.event.NotesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotesEventProcessor
extends EventProcessor<NotesEvent> {
    private final FlowSheetConfigService configService;
    private static final Logger log = LoggerFactory.getLogger(NotesEventProcessor.class);

    public NotesEventProcessor(IArchetypeService service, FlowSheetConfigService configService) {
        super(service);
        this.configService = configService;
    }

    @Override
    public void process(NotesEvent event) {
        FlowSheetConfig config = this.configService.getConfig();
        if (config.isSynchroniseNotes()) {
            Notes notes = (Notes)event.getObject();
            if (notes != null && notes.getNotes() != null) {
                for (Note note : notes.getNotes()) {
                    this.process(note, config);
                }
            }
        } else {
            log.debug("Note synchronisation is disabled - notes will be ignored");
        }
    }

    protected void process(Note note, FlowSheetConfig config) {
        Act visit = this.getVisit(note.getHospitalizationId());
        if (visit != null) {
            this.process(note, visit, config);
        } else {
            log.error("No visit for hospitalization: " + note.getHospitalizationId());
        }
    }

    private void process(Note note, Act visit, FlowSheetConfig config) {
        IArchetypeService service = this.getService();
        Act act = this.getNote(note, visit);
        String status = note.getStatus();
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        if ("removed".equals(status)) {
            if (act != null) {
                if (!"POSTED".equals(act.getStatus())) {
                    service.remove((IMObject)act);
                } else {
                    Party patient = this.getPatient(visit);
                    String text = FlowSheetMessages.cannotDeleteFinalisedNote();
                    this.addAddendum(visit, act, patient, text, toSave);
                }
            }
        } else {
            IMObjectBean bean = null;
            Party patient = this.getPatient(visit);
            if (act == null) {
                if (!this.exclude(note, config)) {
                    act = (Act)service.create("act.patientClinicalNote", Act.class);
                    bean = service.getBean((IMObject)act);
                    bean.setTarget("patient", (IMObject)patient);
                    ActIdentity identity = this.createIdentity(note.getNoteGuid());
                    act.addIdentity(identity);
                    IMObjectBean visitBean = service.getBean((IMObject)visit);
                    ActRelationship relationship = (ActRelationship)visitBean.addTarget("items", (IMObject)act);
                    act.addActRelationship(relationship);
                    toSave.add((IMObject)visit);
                } else if (log.isDebugEnabled()) {
                    log.debug("Excluding note=" + note.getText());
                }
            } else {
                bean = service.getBean((IMObject)act);
            }
            if (bean != null) {
                if ("POSTED".equals(act.getStatus())) {
                    this.addAddendum(visit, act, patient, note.getText(), toSave);
                } else {
                    bean.setValue("note", (Object)note.getText());
                    toSave.add((IMObject)act);
                }
            }
        }
        if (!toSave.isEmpty()) {
            service.save(toSave);
        }
    }

    private boolean exclude(Note note, FlowSheetConfig config) {
        int count;
        boolean result = false;
        int minimumWordCount = config.getMinimumWordCount();
        if (minimumWordCount > 1 && (count = this.countWords(note)) < minimumWordCount) {
            result = true;
        }
        return result;
    }

    private int countWords(Note note) {
        String text = note.getText();
        return text != null ? text.trim().split("\\s+").length : 0;
    }

    private void addAddendum(Act visit, Act note, Party patient, String text, List<IMObject> toSave) {
        IArchetypeService service = this.getService();
        IMObjectBean bean = service.getBean((IMObject)note);
        Act addendum = this.createAddendum(patient, text);
        ActRelationship relationship1 = (ActRelationship)bean.addTarget("addenda", (IMObject)addendum);
        addendum.addActRelationship(relationship1);
        IMObjectBean visitBean = service.getBean((IMObject)visit);
        ActRelationship relationship2 = (ActRelationship)visitBean.addTarget("items", (IMObject)addendum);
        addendum.addActRelationship(relationship2);
        toSave.add((IMObject)note);
        toSave.add((IMObject)addendum);
        toSave.add((IMObject)visit);
    }

    private Act createAddendum(Party patient, String note) {
        IArchetypeService service = this.getService();
        Act addendum = (Act)service.create("act.patientClinicalAddendum", Act.class);
        IMObjectBean addendumBean = service.getBean((IMObject)addendum);
        addendumBean.setTarget("patient", (IMObject)patient);
        addendumBean.setValue("note", (Object)note);
        return addendum;
    }

    private Act getNote(Note note, Act visit) {
        ArchetypeQuery query = new ArchetypeQuery("act.patientClinicalNote");
        query.add((IConstraint)Constraints.join((String)"event").add((IConstraint)Constraints.eq((String)"source", (Reference)visit.getObjectReference())));
        query.add((IConstraint)Constraints.join((String)"identities", (BaseArchetypeConstraint)Constraints.shortName((String)"actIdentity.smartflowsheet")).add((IConstraint)Constraints.eq((String)"identity", (Object)note.getNoteGuid())));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.getService(), (IArchetypeQuery)query);
        return iterator.hasNext() ? (Act)iterator.next() : null;
    }
}

