/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.smartflow.event.impl.EventProcessor;
import org.openvpms.smartflow.model.Medic;
import org.openvpms.smartflow.model.Medics;
import org.openvpms.smartflow.model.event.MedicsImportedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedicsImportedEventProcessor
extends EventProcessor<MedicsImportedEvent> {
    private static final Logger log = LoggerFactory.getLogger(MedicsImportedEventProcessor.class);

    public MedicsImportedEventProcessor(IArchetypeService service) {
        super(service);
    }

    @Override
    public void process(MedicsImportedEvent event) {
        Medics object = (Medics)event.getObject();
        if (object != null && object.getMedics() != null) {
            this.imported(object.getMedics());
        }
    }

    private void imported(List<Medic> medics) {
        for (Medic medic : medics) {
            if (medic.getAsyncOperationStatus() != null && medic.getAsyncOperationStatus() < 0) {
                log.error("Failed to synchronise medic=[id=" + medic.getMedicId() + ", name=" + medic.getName() + "]: " + medic.getAsyncOperationMessage());
                continue;
            }
            log.info("Synchronised medic=[id=" + medic.getMedicId() + ", name=" + medic.getName() + "]");
        }
    }
}

