/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.smartflow.event.impl.SmartFlowSheetHelper;
import org.openvpms.smartflow.model.event.Event;

public abstract class EventProcessor<T extends Event> {
    protected static final String SFS_IDENTITY = "actIdentity.smartflowsheet";
    private final IArchetypeService service;

    public EventProcessor(IArchetypeService service) {
        this.service = service;
    }

    public abstract void process(T var1);

    public IMObject getObject(String identifier, String archetype) {
        return SmartFlowSheetHelper.getObject(archetype, identifier, (ArchetypeService)this.service);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected Act getVisit(String hospitalizationId) {
        return (Act)this.getObject(hospitalizationId, "act.patientClinicalEvent");
    }

    protected Party getPatient(Act visit) {
        IMObjectBean bean = this.service.getBean((IMObject)visit);
        return (Party)bean.getTarget("patient", Party.class);
    }

    protected ActIdentity createIdentity(String guid) {
        ActIdentity identity = (ActIdentity)this.service.create(SFS_IDENTITY, ActIdentity.class);
        identity.setIdentity(guid);
        return identity;
    }
}

