/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.event.impl;

import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.event.EventDispatcher;
import org.openvpms.smartflow.event.impl.AnestheticsEventProcessor;
import org.openvpms.smartflow.event.impl.DischargeEventProcessor;
import org.openvpms.smartflow.event.impl.FlowSheetConfigService;
import org.openvpms.smartflow.event.impl.InventoryImportedEventProcessor;
import org.openvpms.smartflow.event.impl.MedicsImportedEventProcessor;
import org.openvpms.smartflow.event.impl.NotesEventProcessor;
import org.openvpms.smartflow.event.impl.TreatmentEventProcessor;
import org.openvpms.smartflow.model.Hospitalization;
import org.openvpms.smartflow.model.Hospitalizations;
import org.openvpms.smartflow.model.event.AdmissionEvent;
import org.openvpms.smartflow.model.event.AnestheticsEvent;
import org.openvpms.smartflow.model.event.DischargeEvent;
import org.openvpms.smartflow.model.event.Event;
import org.openvpms.smartflow.model.event.InventoryImportedEvent;
import org.openvpms.smartflow.model.event.MedicsImportedEvent;
import org.openvpms.smartflow.model.event.NotesEvent;
import org.openvpms.smartflow.model.event.TreatmentEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultEventDispatcher
implements EventDispatcher {
    private final PracticeService practiceService;
    private final PlatformTransactionManager transactionManager;
    private final TreatmentEventProcessor treatmentProcessor;
    private final NotesEventProcessor notesProcessor;
    private final AnestheticsEventProcessor anestheticsProcessor;
    private final DischargeEventProcessor dischargeProcessor;
    private final InventoryImportedEventProcessor inventoryImportedProcessor;
    private final MedicsImportedEventProcessor medicsImportedProcessor;
    private final Logger log = LoggerFactory.getLogger(DefaultEventDispatcher.class);

    public DefaultEventDispatcher(Party location, IArchetypeService service, LookupService lookups, FlowSheetServiceFactory factory, PracticeService practiceService, PatientRules rules, PlatformTransactionManager transactionManager) {
        this.practiceService = practiceService;
        this.transactionManager = transactionManager;
        FlowSheetConfigService configService = new FlowSheetConfigService(service, practiceService);
        this.treatmentProcessor = new TreatmentEventProcessor(location, service, lookups, rules);
        this.notesProcessor = new NotesEventProcessor(service, configService);
        this.anestheticsProcessor = new AnestheticsEventProcessor(service, factory);
        this.dischargeProcessor = new DischargeEventProcessor(service, factory, configService);
        this.inventoryImportedProcessor = new InventoryImportedEventProcessor(service);
        this.medicsImportedProcessor = new MedicsImportedEventProcessor(service);
    }

    @Override
    public void dispatch(Event<?> event) {
        User user = this.practiceService.getServiceUser();
        if (user == null) {
            throw new IllegalStateException("Missing Practice Service User. Messages cannot be processed until this is configured");
        }
        RunAs.run((User)user, () -> this.dispatchEvent(event));
    }

    protected void admitted(AdmissionEvent event) {
        Hospitalizations list;
        if (this.log.isDebugEnabled() && (list = (Hospitalizations)event.getObject()) != null) {
            for (Hospitalization hospitalization : list.getHospitalizations()) {
                this.log.debug("Admitted: " + hospitalization.getPatient().getName());
            }
        }
    }

    private void dispatchEvent(final Event<?> event) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                if (event instanceof NotesEvent) {
                    DefaultEventDispatcher.this.notesProcessor.process((NotesEvent)event);
                } else if (event instanceof TreatmentEvent) {
                    DefaultEventDispatcher.this.treatmentProcessor.process((TreatmentEvent)event);
                } else if (event instanceof AdmissionEvent) {
                    DefaultEventDispatcher.this.admitted((AdmissionEvent)event);
                } else if (event instanceof DischargeEvent) {
                    DefaultEventDispatcher.this.dischargeProcessor.process((DischargeEvent)event);
                } else if (!(event instanceof AnestheticsEvent)) {
                    if (event instanceof InventoryImportedEvent) {
                        DefaultEventDispatcher.this.inventoryImportedProcessor.process((InventoryImportedEvent)event);
                    } else if (event instanceof MedicsImportedEvent) {
                        DefaultEventDispatcher.this.medicsImportedProcessor.process((MedicsImportedEvent)event);
                    }
                }
            }
        });
    }
}

