/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import org.openvpms.archetype.rules.user.UserQueryFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.smartflow.client.FlowSheetService;
import org.openvpms.smartflow.client.SyncState;
import org.openvpms.smartflow.i18n.FlowSheetMessages;
import org.openvpms.smartflow.model.Department;
import org.openvpms.smartflow.model.Medic;
import org.openvpms.smartflow.model.Medics;
import org.openvpms.smartflow.model.ServiceBusConfig;
import org.openvpms.smartflow.model.TreatmentTemplate;
import org.openvpms.smartflow.service.ReferenceData;
import org.slf4j.LoggerFactory;

public class ReferenceDataService
extends FlowSheetService {
    private final Party location;
    private final IArchetypeService service;

    public ReferenceDataService(String url, String emrApiKey, String clinicApiKey, TimeZone timeZone, Party location, IArchetypeService service) {
        super(url, emrApiKey, clinicApiKey, timeZone, 120, LoggerFactory.getLogger(ReferenceDataService.class));
        this.location = location;
        this.service = service;
    }

    public List<Department> getDepartments() {
        FlowSheetService.Call<List<Department>, ReferenceData> call = new FlowSheetService.Call<List<Department>, ReferenceData>(){

            @Override
            public List<Department> call(ReferenceData resource) throws Exception {
                List<Department> departments = resource.getDepartments();
                if (departments == null) {
                    departments = new ArrayList<Department>();
                }
                return departments;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetDepartments();
            }
        };
        return this.call(ReferenceData.class, call);
    }

    public List<Medic> getMedics() {
        FlowSheetService.Call<List<Medic>, ReferenceData> call = new FlowSheetService.Call<List<Medic>, ReferenceData>(){

            @Override
            public List<Medic> call(ReferenceData resource) throws Exception {
                List<Medic> medics = resource.getMedics();
                if (medics == null) {
                    medics = new ArrayList<Medic>();
                }
                return medics;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetMedics();
            }
        };
        return this.call(ReferenceData.class, call);
    }

    public void updateMedics(final List<Medic> medics, final UUID uuid) {
        FlowSheetService.Call<Void, ReferenceData> call = new FlowSheetService.Call<Void, ReferenceData>(){

            @Override
            public Void call(ReferenceData resource) throws Exception {
                Medics update = new Medics();
                update.setMedics(medics);
                update.setId(uuid.toString());
                resource.updateMedics(update);
                return null;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToUpdateMedics();
            }
        };
        this.call(ReferenceData.class, call);
    }

    public void removeMedic(final Medic medic) {
        FlowSheetService.Call<Void, ReferenceData> call = new FlowSheetService.Call<Void, ReferenceData>(){

            @Override
            public Void call(ReferenceData resource) throws Exception {
                resource.removeMedic(medic.getMedicId());
                return null;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToRemoveMedic(medic.getMedicId(), medic.getName());
            }
        };
        this.call(ReferenceData.class, call);
    }

    public SyncState synchroniseMedics() {
        Iterator<User> clinicians = this.getClinicians();
        Map<String, Medic> medicMap = this.getMedicMap();
        int added = 0;
        int updated = 0;
        int removed = 0;
        ArrayList<Medic> changed = new ArrayList<Medic>();
        while (clinicians.hasNext()) {
            String id;
            Medic currentMedic;
            User clinician = clinicians.next();
            Medic updatedMedic = this.synchronise(clinician, currentMedic = medicMap.remove(id = Long.toString(clinician.getId())), id);
            if (updatedMedic == null) continue;
            changed.add(updatedMedic);
            if (currentMedic == null) {
                ++added;
                continue;
            }
            ++updated;
        }
        if (!changed.isEmpty()) {
            this.updateMedics(changed, UUID.randomUUID());
        }
        for (Medic item : medicMap.values()) {
            this.removeMedic(item);
            ++removed;
        }
        return new SyncState(added, updated, removed);
    }

    public List<String> getTreatmentTemplates() {
        FlowSheetService.Call<List<String>, ReferenceData> call = new FlowSheetService.Call<List<String>, ReferenceData>(){

            @Override
            public List<String> call(ReferenceData resource) throws Exception {
                ArrayList<String> templates = new ArrayList<String>();
                for (TreatmentTemplate template : resource.getTemplates()) {
                    templates.add(template.getName());
                }
                return templates;
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetTemplates();
            }
        };
        return this.call(ReferenceData.class, call);
    }

    public ServiceBusConfig getServiceBusConfig() {
        FlowSheetService.Call<ServiceBusConfig, ReferenceData> call = new FlowSheetService.Call<ServiceBusConfig, ReferenceData>(){

            @Override
            public ServiceBusConfig call(ReferenceData resource) throws Exception {
                return resource.getServiceBusConfig();
            }

            @Override
            public Message getMessage(Exception exception) {
                return FlowSheetMessages.failedToGetServiceBusConfig();
            }
        };
        return this.call(ReferenceData.class, call);
    }

    private Medic synchronise(User clinician, Medic medic, String id) {
        Medic result = null;
        String name = clinician.getName();
        if (medic == null || !Objects.equals(name, medic.getName())) {
            result = new Medic();
            result.setMedicId(id);
            result.setName(name);
        }
        return result;
    }

    private Iterator<User> getClinicians() {
        ArchetypeQuery query = UserQueryFactory.createClinicianQuery((Party)this.location, (String[])new String[]{"id"});
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    private Map<String, Medic> getMedicMap() {
        HashMap<String, Medic> result = new HashMap<String, Medic>();
        for (Medic medic : this.getMedics()) {
            result.put(medic.getMedicId(), medic);
        }
        return result;
    }
}

