/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.smartflow.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.openvpms.smartflow.model.Anesthetics;
import org.openvpms.smartflow.model.Hospitalization;
import org.openvpms.smartflow.model.Hospitalizations;
import org.openvpms.smartflow.model.InventoryItems;
import org.openvpms.smartflow.model.Medics;
import org.openvpms.smartflow.model.Notes;
import org.openvpms.smartflow.model.Treatment;
import org.openvpms.smartflow.model.Treatments;
import org.openvpms.smartflow.model.event.AdmissionEvent;
import org.openvpms.smartflow.model.event.AnestheticsEvent;
import org.openvpms.smartflow.model.event.DischargeEvent;
import org.openvpms.smartflow.model.event.Event;
import org.openvpms.smartflow.model.event.InventoryImportedEvent;
import org.openvpms.smartflow.model.event.MedicsImportedEvent;
import org.openvpms.smartflow.model.event.NotesEvent;
import org.openvpms.smartflow.model.event.TreatmentEvent;
import org.openvpms.smartflow.model.event.UnsupportedEvent;

public class EventDeserializer
extends StdDeserializer<Event> {
    protected EventDeserializer() {
        super(Event.class);
    }

    public Event deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken currentToken;
        String clinicApiKey = null;
        String eventType = null;
        Event result = null;
        block12: while ((currentToken = parser.nextValue()) != null) {
            switch (currentToken) {
                case VALUE_STRING: {
                    switch (parser.getCurrentName()) {
                        case "clinicApiKey": {
                            clinicApiKey = parser.getText();
                            break;
                        }
                        case "eventType": {
                            eventType = parser.getText();
                            break;
                        }
                    }
                    continue block12;
                }
                case START_OBJECT: {
                    if ("hospitalizations.created".equals(eventType)) {
                        result = this.createMultipleAdmission(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("hospitalization.created".equals(eventType)) {
                        result = this.createAdmission(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("hospitalizations.discharged".equals(eventType)) {
                        result = this.createMultipleDischarge(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("hospitalization.discharged".equals(eventType)) {
                        result = this.createDischarge(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("treatment.record_entered".equals(eventType)) {
                        result = this.createTreatment(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("treatments.records_entered".equals(eventType)) {
                        result = this.createMultipleTreatments(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("inventoryitems.imported".equals(eventType)) {
                        result = this.createInventoryImported(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("medics.imported".equals(eventType)) {
                        result = this.createMedicsImported(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("notes.entered".equals(eventType)) {
                        result = this.createNotesEvent(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    if ("anesthetics.finalized".equals(eventType)) {
                        result = this.createAnestheticsEvent(parser, clinicApiKey, eventType);
                        continue block12;
                    }
                    result = this.populate(new UnsupportedEvent(), clinicApiKey, eventType);
                    return result;
                }
            }
        }
        return result;
    }

    protected Event createMultipleAdmission(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        AdmissionEvent event = this.populate(new AdmissionEvent(), clinicApiKey, eventType);
        event.setObject(parser.readValueAs(Hospitalizations.class));
        return event;
    }

    protected Event createAdmission(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        AdmissionEvent event = this.populate(new AdmissionEvent(), clinicApiKey, eventType);
        event.setObject(parser.readValueAs(Hospitalizations.class));
        return event;
    }

    protected Event createDischarge(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        DischargeEvent event = this.populate(new DischargeEvent(), clinicApiKey, eventType);
        Hospitalization hospitalization = (Hospitalization)parser.readValueAs(Hospitalization.class);
        Hospitalizations list = new Hospitalizations();
        list.getHospitalizations().add(hospitalization);
        event.setObject(list);
        return event;
    }

    protected Event createMultipleDischarge(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        DischargeEvent event = this.populate(new DischargeEvent(), clinicApiKey, eventType);
        event.setObject(parser.readValueAs(Hospitalizations.class));
        return event;
    }

    private Event createTreatment(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        TreatmentEvent event = this.populate(new TreatmentEvent(), clinicApiKey, eventType);
        Treatment treatment = (Treatment)parser.readValueAs(Treatment.class);
        Treatments list = new Treatments();
        list.getTreatments().add(treatment);
        event.setObject(list);
        return event;
    }

    private Event createMultipleTreatments(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        TreatmentEvent event = this.populate(new TreatmentEvent(), clinicApiKey, eventType);
        Treatments treatments = (Treatments)parser.readValueAs(Treatments.class);
        event.setObject(treatments);
        return event;
    }

    private Event createNotesEvent(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        NotesEvent event = this.populate(new NotesEvent(), clinicApiKey, eventType);
        Notes notes = (Notes)parser.readValueAs(Notes.class);
        event.setObject(notes);
        return event;
    }

    private Event createAnestheticsEvent(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        AnestheticsEvent event = this.populate(new AnestheticsEvent(), clinicApiKey, eventType);
        Anesthetics anesthetics = (Anesthetics)parser.readValueAs(Anesthetics.class);
        event.setObject(anesthetics);
        return event;
    }

    private Event createInventoryImported(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        InventoryImportedEvent event = this.populate(new InventoryImportedEvent(), clinicApiKey, eventType);
        InventoryItems items = (InventoryItems)parser.readValueAs(InventoryItems.class);
        event.setObject(items);
        return event;
    }

    private Event createMedicsImported(JsonParser parser, String clinicApiKey, String eventType) throws IOException {
        MedicsImportedEvent event = this.populate(new MedicsImportedEvent(), clinicApiKey, eventType);
        Medics medics = (Medics)parser.readValueAs(Medics.class);
        event.setObject(medics);
        return event;
    }

    private <T extends Event> T populate(T event, String clinicApiKey, String eventType) {
        event.setClinicApiKey(clinicApiKey);
        event.setEventType(eventType);
        return event;
    }
}

