/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.sample.service;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.domain.laboratory.Laboratory;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.sync.Changes;
import org.openvpms.laboratory.order.Document;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.order.OrderConfirmation;
import org.openvpms.laboratory.report.ExternalResults;
import org.openvpms.laboratory.report.Report;
import org.openvpms.laboratory.report.ReportBuilder;
import org.openvpms.laboratory.report.Result;
import org.openvpms.laboratory.report.ResultsBuilder;
import org.openvpms.laboratory.sample.internal.SpeciesTargets;
import org.openvpms.laboratory.service.InvestigationTypes;
import org.openvpms.laboratory.service.Laboratories;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.OrderValidationStatus;
import org.openvpms.laboratory.service.Orders;
import org.openvpms.laboratory.service.Tests;
import org.openvpms.mapping.model.Cardinality;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Targets;
import org.openvpms.mapping.service.MappingProvider;
import org.openvpms.mapping.service.MappingService;
import org.openvpms.plugin.service.archetype.ArchetypeInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class SampleLaboratoryService
implements LaboratoryService,
MappingProvider,
DisposableBean {
    private final Laboratories laboratories;
    private final InvestigationTypes investigationTypes;
    private final Tests tests;
    private final Orders orders;
    private final ArchetypeService service;
    private final MappingService mappingService;
    private final ScheduledExecutorService executorService;
    private static final Logger log = LoggerFactory.getLogger(SampleLaboratoryService.class);
    private static final String TYPE_ID = "entityIdentity.investigationTypeSample";
    private static final String TEST_CODE = "entityIdentity.laboratoryTestSample";
    private static final String SAMPLE_LABORATORY_SERVICE = "entity.laboratoryServiceSample";
    private static final String ORDER_ID = "actIdentity.laboratoryOrderSample";

    public SampleLaboratoryService(Laboratories laboratories, InvestigationTypes investigationTypes, Tests tests, Orders orders, ArchetypeService service, ArchetypeInstaller installer, MappingService mappingService) {
        this.laboratories = laboratories;
        this.investigationTypes = investigationTypes;
        this.tests = tests;
        this.orders = orders;
        this.service = service;
        this.mappingService = mappingService;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.install(installer, TYPE_ID);
        this.install(installer, TEST_CODE);
        this.install(installer, SAMPLE_LABORATORY_SERVICE);
        this.install(installer, ORDER_ID);
    }

    public String getName() {
        return "Sample Laboratory Service";
    }

    public String getLaboratoryArchetype() {
        return SAMPLE_LABORATORY_SERVICE;
    }

    public OrderValidationStatus validate(Order order) {
        if (order.getClinician() == null) {
            return OrderValidationStatus.error((String)"Clinician is required");
        }
        Patient patient = order.getPatient();
        if (patient.getDateOfBirth() == null) {
            return OrderValidationStatus.error((String)"The patient must have a date of birth");
        }
        if (patient.getBreedName() == null) {
            return OrderValidationStatus.error((String)"The patient must have a breed");
        }
        if (order.getCustomer() == null) {
            return OrderValidationStatus.error((String)"The order must have a customer");
        }
        String species = patient.getSpeciesCode();
        for (Test test : order.getTests()) {
            if (!"CAN".equals(test.getCode()) || "CANINE".equals(species)) continue;
            return OrderValidationStatus.error((String)(test.getName() + " can only be requested for CANINE patients"));
        }
        if (patient.getSex() == Patient.Sex.UNSPECIFIED) {
            return OrderValidationStatus.warning((String)"No patient gender specified");
        }
        return OrderValidationStatus.valid();
    }

    public boolean confirmOrders(Test test) {
        return false;
    }

    public boolean canCheck(Order order) {
        return false;
    }

    public boolean check(Order order) {
        return false;
    }

    public Document getRequestForm(Order order) {
        return null;
    }

    public void order(Order order) {
        Laboratory laboratory = order.getLaboratory();
        IMObjectBean bean = this.service.getBean((IMObject)laboratory);
        int orderDelay = bean.getInt("orderDelay");
        if (orderDelay == 0) {
            this.submitted(order, laboratory);
        } else {
            order.setStatus(Order.Status.SUBMITTING);
            this.executorService.schedule(() -> this.asyncSubmit(order, laboratory), (long)orderDelay, TimeUnit.SECONDS);
        }
    }

    public OrderConfirmation getOrderConfirmation(Order order) {
        return null;
    }

    public void cancel(Order order) {
        Laboratory laboratory = order.getLaboratory();
        IMObjectBean bean = this.service.getBean((IMObject)laboratory);
        int cancelDelay = bean.getInt("cancelDelay");
        if (cancelDelay == 0) {
            order.setStatus(Order.Status.CANCELLED);
        } else {
            order.setStatus(Order.Status.SUBMITTING);
            this.executorService.schedule(() -> order.setStatus(Order.Status.CANCELLED), (long)cancelDelay, TimeUnit.SECONDS);
        }
    }

    public ExternalResults getExternalResults(Order order) {
        return null;
    }

    public synchronized void synchroniseData(Changes<Entity> changes) {
        List list = this.laboratories.getLaboratories(SAMPLE_LABORATORY_SERVICE, true);
        Laboratory laboratory = !list.isEmpty() ? (Laboratory)list.get(0) : null;
        InvestigationType type = this.investigationTypes.getInvestigationTypeBuilder().changes(changes).typeId(TYPE_ID, "INHOUSE_ID").name("Sample Laboratory Service").description("Investigation Type for tests performed by the Sample Laboratory Service").laboratory(laboratory).build();
        this.addTest("HEM", "Sample Haematology", "Sample Haematology Test", type, changes);
        this.addTest("FLVFIV", "Sample FelV/FIV", "Sample Feline FeLV/FIV Test", type, changes);
        this.addTest("AVI", "Sample Avian Wellness Profile", "Includes K+, GLOB, NA+, AST, TP, ALB, UA, BA, CK, CA, PHOS, GLU", type, changes);
        this.addTest("CAN", "Sample Canine Wellness Profile", "Includes GLOB, ALP, ALT, TP, CHW, ALB, CRE, TBIL, BUN, CA, PHOS, GLU", type, changes);
    }

    public List<Mappings<?>> getMappings() {
        Lookup config = this.mappingService.getMappingConfiguration("org.openvpms.laboratory.sample.species", true, Cardinality.MANY_TO_ONE);
        SpeciesTargets species = new SpeciesTargets("Sample Laboratory Species", "DOG", "CAT", "COW", "HORSE", "PIG", "OTHER");
        Mappings mappings = this.mappingService.createMappings((IMObject)config, Lookup.class, "lookup.species", "Species Mapping", (Targets)species);
        return Collections.singletonList(mappings);
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    private void asyncSubmit(Order order, Laboratory laboratory) {
        try {
            order = this.orders.getOrder(order.getInvestigationId());
            if (order != null && order.getType() != Order.Type.CANCEL) {
                this.submitted(order, laboratory);
            }
        }
        catch (Throwable exception) {
            log.error("Failed to submit order", exception);
        }
    }

    private void submitted(Order order, Laboratory laboratory) {
        order.setOrderId(ORDER_ID, UUID.randomUUID().toString());
        order.setStatus(Order.Status.SUBMITTED);
        IMObjectBean bean = this.service.getBean((IMObject)laboratory);
        int resultsDelay = bean.getInt("resultsDelay");
        if (resultsDelay > 0) {
            this.executorService.schedule(() -> this.waitingForSample(order.getOrderId()), (long)(resultsDelay / 2), TimeUnit.SECONDS);
        }
        this.executorService.schedule(() -> this.generateResults(order.getOrderId()), (long)resultsDelay, TimeUnit.SECONDS);
    }

    private void waitingForSample(String orderId) {
        Order order = this.orders.getOrder(ORDER_ID, orderId);
        if (order != null && order.getType() != Order.Type.CANCEL) {
            order.getReportBuilder().status(Report.Status.WAITING_FOR_SAMPLE).build();
        }
    }

    private void generateResults(String orderId) {
        try {
            Order order = this.orders.getOrder(ORDER_ID, orderId);
            int id = 1;
            if (order != null && order.getType() != Order.Type.CANCEL) {
                ReportBuilder builder = order.getReportBuilder();
                ThreadLocalRandom random = ThreadLocalRandom.current();
                for (Test test : order.getTests()) {
                    ResultsBuilder resultsBuilder = builder.results(Integer.toString(id++)).test(test).date(OffsetDateTime.now()).notes("Some notes for " + test.getName());
                    int count = random.nextInt(1, 11);
                    for (int i = 0; i < count; ++i) {
                        BigDecimal extremeLowRange = new BigDecimal(0);
                        BigDecimal lowRange = new BigDecimal(10);
                        BigDecimal highRange = new BigDecimal(20);
                        BigDecimal extremeHighRange = new BigDecimal(30);
                        BigDecimal value = BigDecimal.valueOf(random.nextDouble(0.0, extremeHighRange.intValue()));
                        String note = value.compareTo(lowRange) < 0 ? "Below low range" : (value.compareTo(highRange) <= 0 ? "Within range" : "Above high range");
                        int code = i + 1;
                        resultsBuilder.result(Integer.toString(code)).status(Result.Status.COMPLETED).analyteCode(test.getCode() + "_ANALYTE" + code).analyteName(test.getName() + " Analyte " + code).value(value).units("g/L").lowRange(lowRange).highRange(highRange).extremeLowRange(extremeLowRange).extremeHighRange(extremeHighRange).notes(note).add();
                    }
                    resultsBuilder.add();
                }
                builder.status(Report.Status.COMPLETED).build();
            }
        }
        catch (Throwable exception) {
            log.error("Failed to generate results", exception);
        }
    }

    private void install(ArchetypeInstaller installer, String archetype) {
        String path = "/org/openvpms/laboratory/sample/internal/" + archetype + ".adl";
        installer.install(this.getClass(), path);
    }

    private void addTest(String testCode, String name, String description, InvestigationType type, Changes<Entity> changes) {
        this.tests.getTestBuilder().changes(changes).testCode(TEST_CODE, testCode).name(name).description(description).investigationType(type).build();
    }
}

