/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.insurance.sample.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.OffsetDateTime;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.sync.Changes;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.Claims;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.policy.Policy;
import org.openvpms.insurance.sample.internal.SampleInsuranceMessages;
import org.openvpms.insurance.service.ClaimValidationStatus;
import org.openvpms.insurance.service.Declaration;
import org.openvpms.insurance.service.GapClaimAvailability;
import org.openvpms.insurance.service.GapInsuranceService;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.Insurers;
import org.openvpms.insurance.service.PolicyValidationStatus;
import org.openvpms.plugin.service.archetype.ArchetypeInstaller;
import org.openvpms.plugin.service.config.ConfigurableService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GapInsuranceService.class, InsuranceService.class, ConfigurableService.class})
public class SampleInsuranceService
implements GapInsuranceService,
ConfigurableService {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private ArchetypeService service;
    private Entity config;
    private Claims claims;
    private Insurers insurers;
    private boolean canSubmitPartialInvoices;
    private volatile int acceptDelay = 30;
    private volatile int benefitDelay = 30;
    private volatile int cancelDelay = 30;
    private volatile int settleDelay = 30;
    private volatile int declineDelay = 30;
    private volatile String notFoundPoliciesEndingWith;
    private volatile String expiredPoliciesEndingWith;
    private volatile String cancelPoliciesEndingWith;
    private volatile String declinePoliciesEndingWith;
    private volatile String zeroBenefitPoliciesEndingWith;
    private volatile String preSettlePoliciesEndingWith;
    private static final String INSURANCE_SERVICE_ARCHETYPE = "entity.insuranceServiceSample";
    private static final String INSURER_ID_ARCHETYPE = "entityIdentity.insurerSample";
    private static final String GAP_INSURER_ID_ARCHETYPE = "entityIdentity.insurerSampleGap";
    private static final String CLAIM_ID_ARCHETYPE = "actIdentity.insuranceClaimSample";
    private static final String DEPOSIT_ID_ARCHETYPE = "actIdentity.insuranceDepositSample";
    private static final String[] ARCHETYPES = new String[]{"/entity.insuranceServiceSample.adl", "/actIdentity.insuranceClaimSample.adl", "/entityIdentity.insurerSample.adl", "/actIdentity.insuranceDepositSample.adl", "/entityIdentity.insurerSampleGap.adl"};

    @Deactivate
    public void deactivate() {
        this.executorService.shutdown();
    }

    public synchronized void setConfiguration(IMObject config) {
        this.config = (Entity)config;
        if (config != null && this.service != null) {
            IMObjectBean bean = this.service.getBean(config);
            this.canSubmitPartialInvoices = bean.getBoolean("canSubmitPartialInvoices");
            this.acceptDelay = bean.getInt("acceptDelay");
            this.benefitDelay = bean.getInt("benefitDelay");
            this.cancelDelay = bean.getInt("cancelDelay");
            this.declineDelay = bean.getInt("declineDelay");
            this.settleDelay = bean.getInt("settleDelay");
            this.expiredPoliciesEndingWith = bean.getString("expiredPoliciesEndingWith");
            this.notFoundPoliciesEndingWith = bean.getString("notFoundPoliciesEndingWith");
            this.cancelPoliciesEndingWith = bean.getString("cancelPoliciesEndingWith");
            this.declinePoliciesEndingWith = bean.getString("declinePoliciesEndingWith");
            this.zeroBenefitPoliciesEndingWith = bean.getString("zeroBenefitPoliciesEndingWith");
            this.preSettlePoliciesEndingWith = bean.getString("preSettlePoliciesEndingWith");
        }
    }

    public synchronized IMObject getConfiguration() {
        return this.config;
    }

    public String getName() {
        return "Sample Insurance Service";
    }

    public String getArchetype() {
        return INSURANCE_SERVICE_ARCHETYPE;
    }

    @Reference
    public void setArchetypeInstaller(ArchetypeInstaller installer) {
        installer.install(this.getClass(), ARCHETYPES);
    }

    @Reference
    public synchronized void setArchetypeService(ArchetypeService service) {
        this.service = service;
    }

    @Reference
    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    @Reference
    public void setInsurers(Insurers insurers) {
        this.insurers = insurers;
    }

    public void synchroniseInsurers(Changes<Party> changes) {
        if (this.insurers != null && this.config != null) {
            this.addInsurer(INSURER_ID_ARCHETYPE, "S1", "Sample Insurer 1", changes);
            this.addInsurer(INSURER_ID_ARCHETYPE, "S2", "Sample Insurer 2", changes);
            this.addInsurer(INSURER_ID_ARCHETYPE, "S3", "Sample Insurer 3", changes);
            this.addInsurer(GAP_INSURER_ID_ARCHETYPE, "G1", "Sample Gap Insurer 1", changes);
            this.addInsurer(GAP_INSURER_ID_ARCHETYPE, "G2", "Sample Gap Insurer 2", changes);
            this.addInsurer(GAP_INSURER_ID_ARCHETYPE, "G3", "Sample Gap Insurer 3", changes);
        }
    }

    public boolean canSubmitPartialInvoices() {
        return this.canSubmitPartialInvoices;
    }

    public Declaration getDeclaration(Claim claim) {
        return () -> "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
    }

    public PolicyValidationStatus validate(Policy policy, Location location) {
        PolicyValidationStatus result;
        Party insurer = policy.getInsurer();
        String insurerId = this.insurers.getInsurerId(insurer);
        String policyNumber = policy.getPolicyNumber();
        if (policyNumber == null || !policyNumber.startsWith(insurerId)) {
            Message message = SampleInsuranceMessages.invalidPolicyNumber(policyNumber, insurer, insurerId);
            result = PolicyValidationStatus.invalid((String)message.getMessage());
        } else if (policyNumber.length() != 10) {
            Message message = SampleInsuranceMessages.policyNumberMustBe10Chars();
            result = PolicyValidationStatus.invalid((String)message.getMessage());
        } else {
            result = this.policyNumberEndsWith(policyNumber, this.notFoundPoliciesEndingWith) ? PolicyValidationStatus.notFound() : (this.policyNumberEndsWith(policyNumber, this.expiredPoliciesEndingWith) ? PolicyValidationStatus.expired() : PolicyValidationStatus.valid());
        }
        return result;
    }

    protected void calculateBenefit(String claimId) {
        GapClaim claim = (GapClaim)this.getClaim(claimId);
        boolean scheduled = false;
        if (claim.getStatus() == Claim.Status.ACCEPTED && claim.getGapStatus() == GapClaim.GapStatus.PENDING) {
            if (this.policyNumberEndsWith(claim.getPolicy().getPolicyNumber(), this.zeroBenefitPoliciesEndingWith)) {
                claim.setBenefit(BigDecimal.ZERO, "No benefit payable. Has reached policy annual limits. Customer to pay full invoice.");
                this.scheduleSettle(claimId);
                scheduled = true;
            } else {
                BigDecimal amount = claim.getTotal().multiply(new BigDecimal("0.75")).setScale(2, RoundingMode.HALF_UP);
                claim.setBenefit(amount, "Claim accepted");
            }
        }
        if (!scheduled && this.policyNumberEndsWith(claim.getPolicy().getPolicyNumber(), this.preSettlePoliciesEndingWith)) {
            this.schedule(claimId, this::preSettleGapClaim, this.settleDelay);
        }
    }

    public ClaimValidationStatus validate(Claim claim) {
        PolicyValidationStatus status = this.validate(claim.getPolicy(), claim.getLocation());
        switch (status.getStatus()) {
            case INVALID: {
                return ClaimValidationStatus.error((String)status.getMessage());
            }
            case NOT_FOUND: {
                return ClaimValidationStatus.error((String)"The policy was not found");
            }
            case EXPIRED: {
                return ClaimValidationStatus.error((String)"The policy has expired");
            }
            case UNSUPPORTED: {
                return ClaimValidationStatus.warning((String)"The policy number could not be validated.");
            }
            case CHANGE_POLICY_NUMBER: {
                return ClaimValidationStatus.error((String)status.getMessage());
            }
        }
        return ClaimValidationStatus.valid();
    }

    public void submit(Claim claim, Declaration declaration) {
        if (claim.getStatus() != Claim.Status.POSTED) {
            throw new IllegalArgumentException("Claim must be POSTED");
        }
        claim.setInsurerId(CLAIM_ID_ARCHETYPE, UUID.randomUUID().toString());
        if (this.acceptDelay == 0) {
            this.accept(claim);
        } else {
            claim.setStatus(Claim.Status.SUBMITTED);
            String claimId = claim.getInsurerId();
            this.executorService.schedule(() -> this.accept(claimId), (long)this.acceptDelay, TimeUnit.SECONDS);
        }
    }

    public boolean canCancel(Claim claim) {
        return claim.getStatus() != Claim.Status.CANCELLED && claim.getStatus() != Claim.Status.CANCELLING && claim.getStatus() != Claim.Status.DECLINED && claim.getStatus() != Claim.Status.SETTLED;
    }

    public void cancel(Claim claim, String message) {
        if (this.cancelDelay == 0) {
            claim.setStatus(Claim.Status.CANCELLED, message);
        } else {
            claim.setStatus(Claim.Status.CANCELLING, message);
            String insurerId = claim.getInsurerId();
            this.executorService.schedule(() -> this.cancel(insurerId), (long)this.cancelDelay, TimeUnit.SECONDS);
        }
    }

    public GapClaimAvailability getGapClaimAvailability(Party insurer, String policyNumber, Location location) {
        Identity insurerId = this.insurers.getIdentifier(insurer);
        return insurerId != null && GAP_INSURER_ID_ARCHETYPE.equals(insurerId.getArchetype()) ? GapClaimAvailability.available() : GapClaimAvailability.notAvailable();
    }

    public void notifyPayment(GapClaim claim) {
        claim.paymentNotified();
        if (claim.getStatus() == Claim.Status.ACCEPTED) {
            this.scheduleSettle(claim.getInsurerId());
        }
    }

    private void addInsurer(String archetype, String id, String name, Changes<Party> changes) {
        Party insurer = this.insurers.getInsurer(archetype, id);
        if (insurer == null) {
            insurer = this.insurers.createInsurer(archetype, id, name, "Online insurer", this.config);
            changes.added((Object)insurer);
        }
    }

    private void scheduleBenefit(String claimId) {
        this.schedule(claimId, this::calculateBenefit, this.benefitDelay);
    }

    private void scheduleSettle(String claimId) {
        this.schedule(claimId, this::settle, this.settleDelay);
    }

    private void cancel(String claimId) {
        Claim.Status status;
        Claim claim = this.getClaim(claimId);
        if (claim != null && (status = claim.getStatus()) != Claim.Status.CANCELLED && status != Claim.Status.SETTLED && status != Claim.Status.DECLINED) {
            claim.setStatus(Claim.Status.CANCELLED);
        }
    }

    private Claim getClaim(String claimId) {
        return this.claims.getClaim(CLAIM_ID_ARCHETYPE, claimId);
    }

    private void accept(String claimId) {
        Claim claim = this.getClaim(claimId);
        if (claim != null) {
            this.accept(claim);
        }
    }

    private void accept(Claim claim) {
        if (claim.getStatus() == Claim.Status.SUBMITTED) {
            String policyNumber = claim.getPolicy().getPolicyNumber();
            if (this.policyNumberEndsWith(policyNumber, this.cancelPoliciesEndingWith)) {
                claim.setStatus(Claim.Status.CANCELLED, "Cancelled by the insurer");
            } else {
                claim.setStatus(Claim.Status.ACCEPTED);
                if (this.policyNumberEndsWith(policyNumber, this.declinePoliciesEndingWith)) {
                    this.scheduleDecline(claim.getInsurerId());
                } else if (claim instanceof GapClaim) {
                    this.scheduleBenefit(claim.getInsurerId());
                } else {
                    this.scheduleSettle(claim.getInsurerId());
                }
            }
        }
    }

    private void preSettleGapClaim(String claimId) {
        GapClaim claim = (GapClaim)this.getClaim(claimId);
        BigDecimal vetBenefit = this.calculateVetBenefit(claim);
        if (vetBenefit.compareTo(BigDecimal.ZERO) != 0) {
            claim.state().vetBenefitAmount(vetBenefit).deposit(UUID.randomUUID().toString(), DEPOSIT_ID_ARCHETYPE, OffsetDateTime.now(), vetBenefit).status(Claim.Status.PRE_SETTLED).update();
        }
    }

    private void settle(String claimId) {
        Claim claim = this.getClaim(claimId);
        if (claim.getStatus() == Claim.Status.ACCEPTED) {
            if (claim instanceof GapClaim) {
                this.settleGapClaim((GapClaim)claim);
            } else {
                claim.setStatus(Claim.Status.SETTLED);
            }
        }
    }

    private void settleGapClaim(GapClaim claim) {
        BigDecimal vetBenefit = this.calculateVetBenefit(claim);
        if (vetBenefit.compareTo(BigDecimal.ZERO) != 0) {
            claim.state().vetBenefitAmount(vetBenefit).deposit(UUID.randomUUID().toString(), DEPOSIT_ID_ARCHETYPE, OffsetDateTime.now(), vetBenefit).status(Claim.Status.SETTLED).update();
        } else {
            claim.setStatus(Claim.Status.SETTLED);
        }
    }

    private void scheduleDecline(String claimId) {
        this.schedule(claimId, this::decline, this.declineDelay);
    }

    private void decline(String claimId) {
        Claim claim = this.getClaim(claimId);
        claim.setStatus(Claim.Status.DECLINED, "Declined by the insurer");
    }

    private void schedule(String claimId, Consumer<String> action, int delay) {
        if (delay == 0) {
            action.accept(claimId);
        } else {
            this.executorService.schedule(() -> action.accept(claimId), (long)delay, TimeUnit.SECONDS);
        }
    }

    private BigDecimal calculateVetBenefit(GapClaim claim) {
        BigDecimal benefit = claim.getBenefitAmount();
        return benefit.multiply(new BigDecimal("0.95")).setScale(2, RoundingMode.HALF_UP);
    }

    private boolean policyNumberEndsWith(String policyNumber, String value) {
        return value != null && policyNumber.endsWith(value);
    }
}

