/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.transaction;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.practice.Location;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.transaction.Receipt;
import org.openvpms.eftpos.transaction.TransactionUpdater;

public interface Transaction {
    public long getId();

    public long getParentId();

    public String getTransactionId();

    public Status getStatus();

    public String getMessage();

    public boolean isComplete();

    public Party getCustomer();

    public Terminal getTerminal();

    public Location getLocation();

    public BigDecimal getAmount();

    public String getCurrencyCode();

    public String getCardType();

    public String getAuthorisationCode();

    public String getResponseCode();

    public String getResponse();

    public String getMaskedCardNumber();

    public String getRetrievalReferenceNumber();

    public String getSystemTraceAuditNumber();

    public List<Receipt> getMerchantReceipts();

    public List<Receipt> getCustomerReceipts();

    public TransactionUpdater state();

    public static enum Status {
        PENDING,
        IN_PROGRESS,
        APPROVED,
        DECLINED,
        ERROR,
        NO_TERMINAL;

    }
}

