/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.i18n.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages {
    private final String bundlePath;
    private final String groupId;
    private final ClassLoader classLoader;
    private static final Logger log = LoggerFactory.getLogger(Messages.class);

    public Messages(String groupId, String bundlePath) {
        this(groupId, bundlePath, null);
    }

    public Messages(String groupId, Class<?> type) {
        this(groupId, type.getName(), type.getClassLoader());
    }

    private Messages(String groupId, String bundlePath, ClassLoader classLoader) {
        this.groupId = groupId;
        this.bundlePath = bundlePath;
        this.classLoader = classLoader;
    }

    public Message create(int code, Object ... args) {
        return this.create(code, Locale.getDefault(), args);
    }

    public Message create(int code, Locale locale, Object ... args) {
        String message = this.getString(Integer.toString(code), locale, args);
        return new Message(this.groupId, code, message);
    }

    public static Message create(String message) {
        return new Message(null, -1, message);
    }

    protected String getString(String key, Locale locale, Object ... args) {
        String result = this.getValue(key, locale);
        if (result == null) {
            result = this.formatMissingKey(key, args);
        } else if (args.length != 0) {
            MessageFormat format = new MessageFormat(result, locale);
            try {
                result = format.format(args);
            }
            catch (Exception exception) {
                result = this.formatFailed(key, result, args, exception);
            }
        }
        return result;
    }

    protected String getValue(String key, Locale locale) {
        ResourceBundle bundle = this.getResourceBundle(locale);
        String result = null;
        try {
            result = StringUtils.trimToNull(bundle.getString(key));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(this.bundlePath, locale, this.getClassLoader());
    }

    protected ClassLoader getClassLoader() {
        ClassLoader result = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
        return result != null ? result : this.getClass().getClassLoader();
    }

    protected String formatMissingKey(String key, Object ... args) {
        log.error("ResourceBundle={} missing key={}", (Object)this.bundlePath, (Object)key);
        StringBuilder result = new StringBuilder("?" + key + "?");
        if (args.length != 0) {
            result.append('[');
            result.append(StringUtils.join(args, ','));
            result.append(']');
        }
        return result.toString();
    }

    protected String formatFailed(String key, String message, Object[] args, Throwable exception) {
        String argText = StringUtils.join(args, ',');
        log.error("Failed to format message, bundle={}, key={}, text='{}', arguments=[{}]", this.bundlePath, key, message, argText, exception);
        StringBuilder result = new StringBuilder("Message='");
        result.append(message);
        result.append("'");
        if (args.length != 0) {
            result.append(". Arguments=[");
            result.append(argText);
            result.append(']');
        }
        return result.toString();
    }
}

