/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.service.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;

public class ContextClassLoaderHelper {
    public static <T> T proxy(T object) {
        Class[] interfaces = ClassUtils.getAllInterfaces(object.getClass()).toArray(new Class[0]);
        InvocationHandler handler = (proxy, method, args) -> ContextClassLoaderHelper.invoke(method, object, args);
        return (T)Proxy.newProxyInstance(object.getClass().getClassLoader(), interfaces, handler);
    }

    public static <T> T proxy(Supplier<T> call) {
        ClassLoader classLoader = call.getClass().getClassLoader();
        T object = ContextClassLoaderHelper.invoke(classLoader, call);
        if (object == null) {
            throw new NullPointerException("Cannot proxy a null object");
        }
        return ContextClassLoaderHelper.proxy(object);
    }

    public static void invoke(ClassLoader loader, Runnable runnable) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invoke(ClassLoader loader, Supplier<T> call) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            T t = call.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private static Object invoke(Method method, Object object, Object[] args) throws Throwable {
        try {
            return ContextClassLoaderHelper.invoke(object.getClass().getClassLoader(), () -> method.invoke(object, args));
        }
        catch (InvocationTargetException exception) {
            throw exception.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T invoke(ClassLoader loader, Callable<T> call) throws Exception {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            T t = call.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }
}

