/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.terminal;

public class TerminalStatus {
    private final boolean registered;
    private final boolean registrationRequired;
    private final boolean canRegister;
    private final boolean error;
    private final String message;

    private TerminalStatus(boolean registered, boolean registrationRequired, boolean canRegister, boolean error, String message) {
        this.registered = registered;
        this.registrationRequired = registrationRequired;
        this.canRegister = canRegister;
        this.error = error;
        this.message = message;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public boolean canRegister() {
        return this.canRegister;
    }

    public boolean isError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public static TerminalStatus registered() {
        return TerminalStatus.newStatus().registered().build();
    }

    public static TerminalStatus registrationRequired() {
        return TerminalStatus.newStatus().unregistered().registrationRequired().canRegister().build();
    }

    public static TerminalStatus error(String message) {
        return TerminalStatus.newStatus().error(message).build();
    }

    public static Builder newStatus() {
        return new Builder();
    }

    public static class Builder {
        private boolean registered;
        private boolean canRegister;
        private boolean registrationRequired;
        private String error;

        public Builder unregistered() {
            this.registered = false;
            return this;
        }

        public Builder registered() {
            this.registered = true;
            return this;
        }

        public Builder canRegister() {
            this.canRegister = true;
            return this;
        }

        public Builder registrationRequired() {
            this.registrationRequired = true;
            return this;
        }

        public Builder error(String message) {
            if (message == null) {
                throw new IllegalArgumentException("Argument 'message' is required");
            }
            this.error = message;
            return this;
        }

        public TerminalStatus build() {
            return new TerminalStatus(this.registered, this.registrationRequired, this.canRegister, this.error != null, this.error);
        }
    }
}

