/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.sample.service;

import java.util.UUID;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.eftpos.sample.internal.service.TransactionDisplayImpl;
import org.openvpms.eftpos.service.EFTPOSService;
import org.openvpms.eftpos.service.Receipts;
import org.openvpms.eftpos.service.TerminalRegistrar;
import org.openvpms.eftpos.service.TransactionDisplay;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.terminal.TerminalStatus;
import org.openvpms.eftpos.transaction.Payment;
import org.openvpms.eftpos.transaction.Refund;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.plugin.service.archetype.ArchetypeInstaller;

public class SampleEFTPOSService
implements EFTPOSService {
    private final ArchetypeService service;
    private static final String TRANSACTION_ID = "actIdentity.EFTPOSTransactionSample";

    public SampleEFTPOSService(ArchetypeService service, ArchetypeInstaller installer) {
        this.service = service;
        installer.install(this.getClass(), "/org/openvpms/eftpos/sample/internal/entity.EFTPOSTerminalSample.adl", "/org/openvpms/eftpos/sample/internal/actIdentity.EFTPOSTransactionSample.adl");
    }

    @Override
    public String getName() {
        return "Sample EFTPOS Service";
    }

    @Override
    public String getTerminalArchetype() {
        return "entity.EFTPOSTerminalSample";
    }

    @Override
    public TerminalStatus getTerminalStatus(Terminal terminal) {
        return TerminalStatus.registered();
    }

    @Override
    public TerminalRegistrar register(Terminal terminal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAvailable(Terminal terminal) {
        return true;
    }

    @Override
    public TransactionDisplay pay(Payment payment) {
        payment.state().transactionId(TRANSACTION_ID, UUID.randomUUID().toString()).status(Transaction.Status.IN_PROGRESS).update();
        return new TransactionDisplayImpl(payment, this.service);
    }

    @Override
    public TransactionDisplay resume(Payment payment) {
        return new TransactionDisplayImpl(payment, this.service);
    }

    @Override
    public TransactionDisplay refund(Refund refund) {
        refund.state().transactionId(TRANSACTION_ID, UUID.randomUUID().toString()).status(Transaction.Status.IN_PROGRESS).update();
        return new TransactionDisplayImpl(refund, this.service);
    }

    @Override
    public TransactionDisplay resume(Refund refund) {
        return new TransactionDisplayImpl(refund, this.service);
    }

    @Override
    public Receipts getLastReceipts(Transaction transaction) {
        return null;
    }
}

