/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.eftpos.sample.internal.service;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.eftpos.service.ManagedTransactionDisplay;
import org.openvpms.eftpos.service.Prompt;
import org.openvpms.eftpos.transaction.Payment;
import org.openvpms.eftpos.transaction.Transaction;

public class TransactionDisplayImpl
implements ManagedTransactionDisplay {
    private final Transaction transaction;
    private final long delay;
    private long lastUpdate;
    private final List<String> messages = new ArrayList<String>();
    private State state = State.PRESENT_CARD;
    private final Random random = new Random();
    private static final String PRESENT_CARD_MSG = "PRESENT/INSERT\nSWIPE CARD";
    private static final String PROCESSING_MSG = "PROCESSING";
    private static final String SELECT_ACCOUNT_MSG = "SELECT ACCOUNT\nCHQ SAV CRD";
    private static final String SIGNATURE_MSG = "SIGNATURE OK?\nYES/NO";
    private static final String PIN_MSG = "AWAITING PIN";
    private static final String APPROVED_MSG = "APPROVED";
    private static final String DECLINED_MSG = "DECLINED";
    private static final String CANCEL = "CANCEL";

    public TransactionDisplayImpl(Transaction transaction, ArchetypeService service) {
        this.transaction = transaction;
        IMObjectBean bean = service.getBean(transaction.getTerminal());
        this.lastUpdate = System.currentTimeMillis();
        this.delay = bean.getLong("delay", 5L) * 1000L;
    }

    @Override
    public synchronized Prompt getPrompt() {
        if (this.state == State.PRESENT_CARD) {
            return new PromptImpl(PRESENT_CARD_MSG, null, CANCEL);
        }
        if (this.state == State.SELECT_ACCOUNT) {
            return new PromptImpl(SELECT_ACCOUNT_MSG, null, CANCEL);
        }
        if (this.state == State.CONFIRM_SIGNATURE) {
            return new PromptImpl(SIGNATURE_MSG, "YES", "NO");
        }
        return null;
    }

    @Override
    public synchronized List<String> getMessages() {
        return this.messages;
    }

    @Override
    public synchronized boolean update() {
        boolean updated = false;
        this.delay();
        if (!this.transaction.isComplete()) {
            switch (this.state) {
                case PRESENT_CARD: {
                    this.messages.add(PRESENT_CARD_MSG);
                    this.state = State.PROCESSING;
                    break;
                }
                case PROCESSING: {
                    this.messages.add(PROCESSING_MSG);
                    this.state = State.SELECT_ACCOUNT;
                    break;
                }
                case SELECT_ACCOUNT: {
                    this.messages.add(SELECT_ACCOUNT_MSG);
                    if (this.usePin()) {
                        this.state = State.ENTER_PIN;
                        break;
                    }
                    this.state = State.SIGNATURE;
                    break;
                }
                case ENTER_PIN: {
                    this.messages.add(PIN_MSG);
                    this.state = State.RESULT;
                    break;
                }
                case SIGNATURE: {
                    this.transaction.state().addMerchantReceipt(this.createMerchantReceipt(this.transaction, new Date()), true).update();
                    this.state = State.CONFIRM_SIGNATURE;
                    break;
                }
                case CONFIRM_SIGNATURE: {
                    break;
                }
                case RESULT: {
                    if (this.transaction.getAmount().toString().endsWith("1")) {
                        this.declined();
                        break;
                    }
                    this.approved();
                }
            }
            updated = true;
        }
        return updated;
    }

    @Override
    public synchronized Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.transaction.isComplete();
    }

    @Override
    public synchronized void cancel() {
        this.transaction.state().status(Transaction.Status.ERROR, "Cancelled by user").update();
    }

    private void approved() {
        this.messages.add(APPROVED_MSG);
        this.completed(Transaction.Status.APPROVED, "00");
    }

    private void declined() {
        this.messages.add(DECLINED_MSG);
        this.completed(Transaction.Status.DECLINED, null);
    }

    private void completed(Transaction.Status status, String authorisationCode) {
        String cardType = this.getCardType();
        String cardNumber = this.getCard();
        String reference = this.getReference();
        boolean payment = this.transaction instanceof Payment;
        this.transaction.state().status(status).cardType(this.getCardType()).authorisationCode(authorisationCode).maskedCardNumber(cardNumber).addCustomerReceipt(this.createCustomerReceipt(status == Transaction.Status.APPROVED, this.transaction.getAmount(), payment, new Date(), cardType, cardNumber, authorisationCode + this.random(4), reference)).update();
    }

    private boolean usePin() {
        return !"MasterCard".equals(this.getCardType());
    }

    private void delay() {
        long now = System.currentTimeMillis();
        long diff = now - this.lastUpdate;
        if (diff < this.delay) {
            LockSupport.parkUntil(now + (this.delay - diff));
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    private String getCardType() {
        long amount = this.transaction.getAmount().toBigInteger().longValue();
        if (amount % 3L == 0L) {
            return "EFTPOS";
        }
        if (amount % 2L == 0L) {
            return "MasterCard";
        }
        return "VISA";
    }

    private String getCard() {
        return "543111******" + this.format(this.transaction.getId(), 4);
    }

    private String getAuthorisation() {
        return this.format(this.transaction.getParentId(), 6);
    }

    private String getReference() {
        return StringUtils.reverse(this.format(this.transaction.getId(), 6));
    }

    private String format(long value, int length) {
        return String.format("%0" + length + "d", value);
    }

    private String createMerchantReceipt(Transaction transaction, Date date) {
        String cardType = this.getCardType();
        String card = this.getCard();
        BigDecimal amount = transaction.getAmount();
        return "OpenVPMS\n12 Wherever St\n\n*---------------EFTPOS--------------*\n\n" + this.padLine(DateFormat.getDateTimeInstance().format(date), "CREDIT") + this.padLine(cardType, "SWIPE") + this.padLine("CARD", card) + this.padLine("AUHORISATION", this.getAuthorisation()) + this.padLine("REFERENCE", this.getReference()) + this.padLine("PURCHASE", this.format(amount)) + this.padLine("TOTAL", this.format(amount)) + "\n              APPROVED\n\n            PLEASE SIGN BELOW\n\n\n*-----------------------------------*\n\n             MERCHANT COPY\n             PLEASE RETAIN\n            FOR YOUR RECORDS\n";
    }

    private String createCustomerReceipt(boolean approved, BigDecimal amount, boolean payment, Date date, String cardType, String card, String authorisation, String reference) {
        StringBuilder result = new StringBuilder();
        result.append("OpenVPMS\n12 Wherever St\n\n*---------------EFTPOS--------------*\n\n");
        result.append(this.padLine(DateFormat.getDateTimeInstance().format(date), "CREDIT"));
        result.append(this.padLine(cardType, "SWIPE"));
        result.append(this.padLine("CARD", card));
        if (approved) {
            result.append(this.padLine("AUTHORISATION", authorisation));
        }
        result.append(this.padLine("REFERENCE", reference));
        result.append(this.padLine(payment ? "PURCHASE" : "REFUND", this.format(amount)));
        result.append(this.padLine("TOTAL", this.format(amount)));
        result.append("\n");
        if (approved) {
            result.append("              APPROVED\n\n            PIN VERIFIED\n\n");
        } else {
            result.append("              DECLINED\n\n");
        }
        result.append("*-----------------------------------*\n\n             CUSTOMER COPY\n             PLEASE RETAIN\n            FOR YOUR RECORDS\n");
        return result.toString();
    }

    private String padLine(String left, String right) {
        return left + String.format("%" + (37 - left.length()) + "s", right) + "\n";
    }

    private String format(BigDecimal amount) {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(2);
        return "AUD" + format.format(amount);
    }

    private String random(int length) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append((char)(48 + this.random.nextInt(10)));
        }
        return result.toString();
    }

    static enum State {
        PRESENT_CARD,
        PROCESSING,
        SELECT_ACCOUNT,
        ENTER_PIN,
        SIGNATURE,
        CONFIRM_SIGNATURE,
        RESULT;

    }

    private static class OptionImpl
    implements Prompt.Option {
        private final String option;

        private OptionImpl(String option) {
            this.option = option;
        }

        @Override
        public String getText() {
            return this.option;
        }

        public boolean isCancel() {
            return TransactionDisplayImpl.CANCEL.equals(this.option);
        }

        public boolean isYes() {
            return "YES".equals(this.option);
        }

        public boolean isNo() {
            return "NO".equals(this.option);
        }
    }

    private class PromptImpl
    implements Prompt {
        private final String message;
        private final List<Prompt.Option> options = new ArrayList<Prompt.Option>();

        public PromptImpl(String message, String option1, String option2) {
            this.message = message;
            if (option1 != null) {
                this.options.add(new OptionImpl(option1));
            }
            if (option2 != null) {
                this.options.add(new OptionImpl(option2));
            }
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public List<Prompt.Option> getOptions() {
            return this.options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Prompt.Option option) {
            OptionImpl opt = (OptionImpl)option;
            TransactionDisplayImpl transactionDisplayImpl = TransactionDisplayImpl.this;
            synchronized (transactionDisplayImpl) {
                if (opt.isCancel()) {
                    if (!TransactionDisplayImpl.this.transaction.isComplete()) {
                        TransactionDisplayImpl.this.transaction.state().status(Transaction.Status.ERROR, "Cancelled by user").update();
                    }
                } else if (opt.isYes()) {
                    if (TransactionDisplayImpl.this.state == State.CONFIRM_SIGNATURE) {
                        TransactionDisplayImpl.this.approved();
                    }
                } else if (opt.isNo() && TransactionDisplayImpl.this.state == State.CONFIRM_SIGNATURE) {
                    TransactionDisplayImpl.this.declined();
                }
            }
        }
    }
}

