/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.query;

public class Filter<T> {
    private final T value;
    private final Operator operator;

    private Filter(T value, Operator operator) {
        this.value = value;
        this.operator = operator;
    }

    public T getValue() {
        return this.value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public static <T> Filter<T> equal(T value) {
        return new Filter<T>(value, Operator.EQUAL);
    }

    public static <T> Filter<T> notEqual(T value) {
        return new Filter<T>(value, Operator.NOT_EQUAL);
    }

    public static Filter<String> like(String value) {
        return new Filter<String>(value, Operator.LIKE);
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LIKE;

    }
}

