/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.model.bean;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.function.Predicate;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;

public final class Predicates {
    private static final Predicate<?> ACTIVE_NOW = new IsActiveAt();

    private Predicates() {
    }

    public static <T extends Relationship> Predicate<T> activeNow() {
        return ACTIVE_NOW;
    }

    public static <T extends Relationship> Predicate<T> activeAt(Date time) {
        return new IsActiveAt(time);
    }

    public static <T extends Relationship> Predicate<T> active(Date from, Date to) {
        return new IsActiveRange(from, to);
    }

    public static <T extends Relationship> Predicate<T> sourceEquals(IMObject object) {
        return new SourceEquals(object);
    }

    public static <T extends Relationship> Predicate<T> sourceEquals(Reference object) {
        return new SourceEquals(object);
    }

    public static <T extends Relationship> Predicate<T> targetEquals(IMObject object) {
        return new TargetEquals(object);
    }

    public static <T extends Relationship> Predicate<T> targetEquals(Reference object) {
        return new TargetEquals(object);
    }

    public static <T extends Relationship> Predicate<T> sourceIsA(String ... archetypes) {
        return new SourceIsA(archetypes);
    }

    public static <T extends Relationship> Predicate<T> targetIsA(String ... archetypes) {
        return new TargetIsA(archetypes);
    }

    public static <T extends IMObject> Predicate<T> isA(String ... archetypes) {
        return new ObjectIsA(archetypes);
    }

    private static class TargetEquals<T extends Relationship>
    extends RefEquals<T> {
        TargetEquals(IMObject object) {
            super(object);
        }

        TargetEquals(Reference ref) {
            super(ref);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TargetEquals && super.equals(obj);
        }

        @Override
        protected boolean test(T relationship, Reference reference) {
            return Objects.equals(reference, relationship.getTarget());
        }
    }

    private static class SourceEquals<T extends Relationship>
    extends RefEquals<T> {
        SourceEquals(IMObject object) {
            super(object);
        }

        SourceEquals(Reference ref) {
            super(ref);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof SourceEquals && super.equals(obj);
        }

        @Override
        protected boolean test(T relationship, Reference reference) {
            return Objects.equals(reference, relationship.getSource());
        }
    }

    private static abstract class RefEquals<T extends Relationship>
    implements Predicate<T> {
        private final Reference ref;

        RefEquals(IMObject object) {
            this(object != null ? object.getObjectReference() : null);
        }

        RefEquals(Reference ref) {
            this.ref = ref;
        }

        @Override
        public boolean test(T relationship) {
            return this.test(relationship, this.ref);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RefEquals) {
                RefEquals other = (RefEquals)obj;
                return Objects.equals(this.ref, other.ref);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.ref);
        }

        protected abstract boolean test(T var1, Reference var2);
    }

    private static class IsActiveRange<T extends Relationship>
    extends IsActive<T> {
        private final Date from;
        private final Date to;

        IsActiveRange(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean test(T relationship) {
            boolean result;
            if (relationship instanceof PeriodRelationship) {
                PeriodRelationship period = (PeriodRelationship)relationship;
                result = period.isActive(this.from, this.to);
            } else {
                result = super.test(relationship);
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IsActiveRange) {
                IsActiveRange other = (IsActiveRange)obj;
                return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }

    private static class IsActiveAt<T extends Relationship>
    extends IsActive<T> {
        private final long time;

        IsActiveAt() {
            this(-1L);
        }

        IsActiveAt(Date time) {
            this(time.getTime());
        }

        IsActiveAt(long time) {
            this.time = time;
        }

        @Override
        public boolean test(T relationship) {
            boolean result;
            if (relationship instanceof PeriodRelationship) {
                PeriodRelationship period = (PeriodRelationship)relationship;
                result = this.time == -1L ? period.isActive() : period.isActive(this.time);
            } else {
                result = super.test(relationship);
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IsActiveAt) {
                IsActiveAt other = (IsActiveAt)obj;
                return this.time == other.time;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.time);
        }
    }

    private static class IsActive<T extends Relationship>
    implements Predicate<T> {
        private IsActive() {
        }

        @Override
        public boolean test(T relationship) {
            return relationship.isActive();
        }

        public boolean equals(Object obj) {
            return obj instanceof IsActive;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class TargetIsA<T extends Relationship>
    extends IsA<T> {
        public TargetIsA(String[] archetypes) {
            super(archetypes);
        }

        @Override
        boolean test(T object, String[] archetypes) {
            Reference reference = object.getTarget();
            return reference != null && reference.isA(archetypes);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TargetIsA && super.equals(obj);
        }
    }

    private static class SourceIsA<T extends Relationship>
    extends IsA<T> {
        public SourceIsA(String[] archetypes) {
            super(archetypes);
        }

        @Override
        boolean test(T object, String[] archetypes) {
            Reference reference = object.getSource();
            return reference != null && reference.isA(archetypes);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof SourceIsA && super.equals(obj);
        }
    }

    private static class ObjectIsA<T extends IMObject>
    extends IsA<T> {
        public ObjectIsA(String[] archetypes) {
            super(archetypes);
        }

        @Override
        boolean test(T object, String[] archetypes) {
            return object.isA(archetypes);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ObjectIsA && super.equals(obj);
        }
    }

    private static abstract class IsA<T>
    implements Predicate<T> {
        private final String[] archetypes;

        public IsA(String[] archetypes) {
            this.archetypes = archetypes;
        }

        @Override
        public boolean test(T object) {
            return this.test(object, this.archetypes);
        }

        abstract boolean test(T var1, String[] var2);

        public boolean equals(Object obj) {
            return obj instanceof IsA && Arrays.equals(this.archetypes, ((IsA)obj).archetypes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.archetypes);
        }
    }
}

