/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.msword;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.local.office.LocalOfficeContext;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeDocument;
import org.openvpms.report.openoffice.OpenOfficeException;

public class MsWordDocument
extends OpenOfficeDocument {
    public MsWordDocument(Document document, LocalOfficeContext context, DocumentHandlers handlers) {
        super(document, context, handlers);
    }

    @Override
    protected String getContent(OpenOfficeDocument.Field field) {
        if (!this.isInputField(field.getPropertySet()) && !field.isChanged()) {
            return field.getValue();
        }
        return super.getContent(field);
    }

    @Override
    protected Map<String, OpenOfficeDocument.Field> getUserTextFields() {
        LinkedHashMap<String, OpenOfficeDocument.Field> result = new LinkedHashMap<String, OpenOfficeDocument.Field>();
        XEnumeration fields = this.getTextFieldsEnumeration();
        if (fields != null) {
            int seed = 0;
            try {
                while (fields.hasMoreElements()) {
                    XPropertySet set;
                    Object field = fields.nextElement();
                    if (!this.isDatabaseField(field) || (set = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)field)) == null) continue;
                    String name = "userField" + ++seed;
                    String fieldCode = this.getFieldCode(name, set);
                    if (!StringUtils.isEmpty((CharSequence)fieldCode) && !result.containsKey(fieldCode)) {
                        name = fieldCode;
                    }
                    result.put(name, new OpenOfficeDocument.Field(name, fieldCode, set));
                }
            }
            catch (Exception exception) {
                throw new OpenOfficeException(ReportMessages.failedToGetOpenOfficeUserFields(this.getName()), exception);
            }
        }
        return result;
    }

    @Override
    protected XPropertySet getInputFieldPropertySet(Object field) {
        return this.isInputField(field) ? (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)field) : null;
    }

    protected String getFieldCode(String name, XPropertySet set) {
        try {
            String value = (String)set.getPropertyValue("FieldCode");
            value = value.replaceAll("(MERGEFIELD|MERGEFORMAT|\\*|\\\\)", "").trim();
            return value;
        }
        catch (Exception exception) {
            throw new OpenOfficeException(ReportMessages.failedToGetOpenOfficeField(name, this.getName()));
        }
    }

    private boolean isDatabaseField(Object field) {
        XServiceInfo info = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)field);
        return info != null && info.supportsService("com.sun.star.text.TextField.Database");
    }
}

