/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.jxpath.Functions;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.report.AbstractReportFactory;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.IMReport;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.msword.MsWordIMReport;
import org.openvpms.report.openoffice.OpenOfficeIMReport;
import org.openvpms.report.openoffice.OpenOfficeService;

public class ReportFactoryImpl
extends AbstractReportFactory {
    private final OpenOfficeService officeService;

    public ReportFactoryImpl(IArchetypeService service, LookupService lookups, DocumentHandlers handlers, ArchetypeFunctionsFactory factory, DocumentRules documentRules, DocumentConverter documentConverter, OpenOfficeService officeService, Settings settings) {
        super(service, lookups, handlers, factory, documentRules, documentConverter, settings);
        this.officeService = officeService;
    }

    @Override
    protected IMReport<IMObject> createDocumentReport(Document document, BaseDocumentTemplate template, ArchetypeService service, Functions functions) {
        OpenOfficeIMReport<IMObject> report;
        String fileName = template.getFileName();
        String ext = FilenameUtils.getExtension((String)fileName);
        if (this.isODT(ext)) {
            report = new OpenOfficeIMReport<IMObject>(document, service, this.getLookups(), this.getHandlers(), functions, this.officeService);
        } else if (this.isDOC(ext)) {
            report = new MsWordIMReport<IMObject>(document, service, this.getLookups(), this.getHandlers(), functions, this.officeService);
        } else {
            throw new ReportException(ReportMessages.unsupportedTemplate(fileName));
        }
        return report;
    }

    @Override
    protected IMReport<ObjectSet> createDocumentObjectSetReport(Document document, BaseDocumentTemplate template, ArchetypeService service, Functions functions) {
        return new OpenOfficeIMReport<ObjectSet>(document, service, this.getLookups(), this.getHandlers(), functions, this.officeService);
    }
}

