/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.util;

import org.apache.commons.lang.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.report.ExpressionEvaluator;
import org.slf4j.Logger;

public class ProtectedExpressionEvaluator {
    private final String reportName;
    private final Logger log;

    public ProtectedExpressionEvaluator(String reportName, Logger log) {
        this.reportName = reportName;
        this.log = log;
    }

    public Object evaluate(String expression, ExpressionEvaluator evaluator, IMObject current) {
        Object result = null;
        try {
            result = evaluator.evaluate(expression);
        }
        catch (Throwable exception) {
            this.log(expression, current, null, exception);
        }
        return result;
    }

    public Object evaluate(Object object, String expression, ExpressionEvaluator evaluator, IMObject current) {
        Object result = null;
        try {
            result = evaluator.evaluate(object, expression);
        }
        catch (Throwable exception) {
            this.log(expression, current, object, exception);
        }
        return result;
    }

    public String getFormattedValue(String expression, ExpressionEvaluator evaluator, IMObject current) {
        String result;
        try {
            result = evaluator.getFormattedValue(expression);
        }
        catch (Throwable exception) {
            result = exception.getMessage();
            this.log(expression, current, null, exception);
        }
        return result;
    }

    public void log(String expression, IMObject current, Object value, Throwable exception) {
        if (this.log.isWarnEnabled()) {
            if (value instanceof IMObject) {
                value = ((IMObject)value).getObjectReference();
            }
            StringBuilder builder = new StringBuilder("Failed to evaluate '" + expression + "' in report=" + this.reportName);
            if (value != null) {
                builder.append(" against object=").append(StringUtils.abbreviate((String)value.toString(), (int)255));
            }
            if (current != null) {
                builder.append(". Current record object=").append(current.getObjectReference());
            }
            builder.append(": ").append(exception.getMessage());
            if (this.log.isWarnEnabled()) {
                this.log.warn(builder.toString());
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(builder.toString(), exception);
            }
        }
    }
}

