/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice.print;

import javax.print.PrintService;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.print.impl.service.AbstractPrintServiceDocumentPrinter;
import org.openvpms.print.service.PrintAttributes;
import org.openvpms.report.PrintProperties;
import org.openvpms.report.openoffice.print.OpenOfficePrintService;

public class OpenOfficeDocumentPrinter
extends AbstractPrintServiceDocumentPrinter {
    private final OpenOfficePrintService openOfficePrintService;

    public OpenOfficeDocumentPrinter(OpenOfficePrintService openOfficePrintService, DocumentHandlers handlers, PrintService printService) {
        super(printService, handlers);
        this.openOfficePrintService = openOfficePrintService;
    }

    public boolean canPrint(String mimeType) {
        return this.isSupportedByOpenOffice(mimeType) || super.canPrint(mimeType);
    }

    public void print(Document document, PrintAttributes attributes) {
        if (this.isSupportedByOpenOffice(document.getMimeType())) {
            PrintProperties properties = new PrintProperties(this.getId(), attributes);
            this.openOfficePrintService.print(this.getDecompressedDocument(document), properties);
        } else {
            super.print(document, attributes);
        }
    }

    private boolean isSupportedByOpenOffice(String mimeType) {
        return "application/vnd.oasis.opendocument.text".equals(mimeType) || "application/msword".equals(mimeType);
    }
}

