/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jodconverter.local.office.LocalOfficeContext;
import org.openvpms.report.openoffice.OpenOfficeService;

public abstract class OpenOfficeTask<T> {
    private final boolean debug;

    public OpenOfficeTask(boolean debug) {
        this.debug = debug;
    }

    public final T run(OpenOfficeService service) {
        Object result;
        RuntimeException failure = null;
        AtomicLong delay = new AtomicLong();
        StopWatch stopWatch = new StopWatch();
        try {
            if (this.debug) {
                this.start();
            }
            result = service.call(context -> {
                if (this.debug) {
                    stopWatch.split();
                    delay.set(stopWatch.getSplitTime());
                    stopWatch.unsplit();
                }
                return this.run((LocalOfficeContext)context);
            });
            if (this.debug) {
                this.stop(null, delay.get(), stopWatch.getTime());
            }
        }
        catch (RuntimeException exception) {
            failure = exception;
            throw failure;
        }
        finally {
            if (this.debug) {
                this.stop(failure, delay.get(), stopWatch.getTime());
            }
        }
        return (T)result;
    }

    protected abstract T run(LocalOfficeContext var1);

    protected void start() {
    }

    protected void stop(Exception exception, long delay, long elapsed) {
    }

    protected String duration(long duration) {
        return DurationFormatUtils.formatDurationHMS((long)duration);
    }
}

