/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.local.office.LocalOfficeContext;
import org.jodconverter.local.office.LocalOfficeManager;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OfficeTaskRunner;
import org.openvpms.report.openoffice.OpenOfficeConfig;
import org.openvpms.report.openoffice.OpenOfficeConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class OpenOfficeService
implements DisposableBean {
    private final Settings settings;
    private final AtomicReference<OpenOfficeConfig> configUsed = new AtomicReference();
    private Long taskExecutionTimeout = 120000L;
    private Long taskQueueTimeout = 30000L;
    private OfficeManager officeManager;
    private static final Logger log = LoggerFactory.getLogger(OpenOfficeService.class);

    public OpenOfficeService(Settings settings) {
        this.settings = settings;
    }

    public void setTaskExecutionTimeout(@Nullable Long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout;
    }

    public void setTaskQueueTimeout(@Nullable Long taskQueueTimeout) {
        this.taskQueueTimeout = taskQueueTimeout;
    }

    public void run(Consumer<LocalOfficeContext> task) {
        Consumer delegator = RunAs.inheritSecurityContext(task);
        this.execute(context -> delegator.accept((LocalOfficeContext)context));
    }

    public <T> T call(Function<LocalOfficeContext, T> task) {
        AtomicReference result = new AtomicReference();
        this.run(context -> result.set(task.apply((LocalOfficeContext)context)));
        return (T)result.get();
    }

    public OpenOfficeConfig getConfig() {
        OpenOfficeConfig result = this.configUsed.get();
        return result != null ? result : this.getCurrentConfig();
    }

    public boolean isRunning() {
        OfficeManager current = this.getOfficeManager();
        return current != null && current.isRunning();
    }

    public synchronized void restart() {
        this.stop();
        this.start();
    }

    public void destroy() {
        this.stop();
    }

    protected synchronized OfficeManager getOfficeManager() {
        return this.officeManager;
    }

    protected synchronized OfficeManager getRunning() {
        if (this.officeManager == null) {
            this.start();
        }
        return this.officeManager;
    }

    private void execute(OfficeTask task) {
        OfficeTaskRunner.run(this::getRunning, task);
    }

    private void start() {
        OpenOfficeConfig config = this.getCurrentConfig();
        String path = config.getPath();
        List<Integer> ports = config.getPorts();
        int maxTasksPerProcess = config.getMaxTasksPerProcess();
        this.configUsed.set(config);
        log.info("Starting OpenOffice at path '{}' on ports={}, maxTasksPerProcess={}", new Object[]{path, StringUtils.join(ports, (char)','), maxTasksPerProcess});
        try {
            this.officeManager = ((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)LocalOfficeManager.builder().officeHome(path).portNumbers(ArrayUtils.toPrimitive((Integer[])ports.toArray(new Integer[0]))).taskExecutionTimeout(this.taskExecutionTimeout)).taskQueueTimeout(this.taskQueueTimeout)).maxTasksPerProcess(Integer.valueOf(config.getMaxTasksPerProcess())).build();
            this.officeManager.start();
        }
        catch (Exception exception) {
            throw new OpenOfficeConnectionException(ReportMessages.failedToConnectToOpenOffice(exception.getMessage()), exception);
        }
    }

    private synchronized void stop() {
        if (this.officeManager != null) {
            OfficeUtils.stopQuietly((OfficeManager)this.officeManager);
            this.officeManager = null;
        }
    }

    private OpenOfficeConfig getCurrentConfig() {
        return new OpenOfficeConfig(this.settings);
    }
}

