/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice;

import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.jodconverter.local.office.LocalOfficeContext;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.document.Document;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeDocument;
import org.openvpms.report.openoffice.OpenOfficeDocumentException;
import org.openvpms.report.openoffice.OpenOfficeException;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.openvpms.report.openoffice.OpenOfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficeDocumentConverter
implements DocumentConverter {
    private final OpenOfficeService officeService;
    private final DocumentHandlers handlers;
    private static final String[][] MIME_MAP = new String[][]{{"application/vnd.oasis.opendocument.text", "application/pdf"}, {"application/msword", "application/pdf"}, {"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/pdf"}, {"text/rtf", "text/html"}};
    private static final String[][] EXT_MAP = new String[][]{{"odt", "application/pdf"}, {"doc", "application/pdf"}, {"docx", "application/pdf"}, {"odt", "text/html"}, {"doc", "text/html"}, {"docx", "text/html"}, {"rtf", "text/html"}};
    private static final Logger log = LoggerFactory.getLogger(OpenOfficeDocumentConverter.class);

    public OpenOfficeDocumentConverter(OpenOfficeService officeService, DocumentHandlers handlers) {
        this.officeService = officeService;
        this.handlers = handlers;
    }

    @Override
    public boolean canConvert(Document document, String mimeType) {
        return this.canConvert(document.getName(), document.getMimeType(), mimeType);
    }

    @Override
    public boolean canConvert(String fileName, String sourceMimeType, String targetMimeType) {
        for (String[] map : MIME_MAP) {
            if (!map[0].equals(sourceMimeType) || !map[1].equals(targetMimeType)) continue;
            return true;
        }
        if (fileName != null) {
            String ext = FilenameUtils.getExtension((String)fileName);
            for (String[] map : EXT_MAP) {
                if (!map[0].equals(ext) || !map[1].equals(targetMimeType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Document convert(Document document, String mimeType) {
        return this.convert(document, mimeType, false);
    }

    @Override
    public Document convert(Document document, String mimeType, boolean email) {
        String name = FilenameUtils.getBaseName((String)document.getName());
        return this.convert(document, mimeType, email, "convert", doc -> doc.export(mimeType, name));
    }

    @Override
    public byte[] export(Document document, String mimeType, boolean email) {
        return this.convert(document, mimeType, email, "export", doc -> doc.export(mimeType));
    }

    private <T> T convert(Document document, String mimeType, boolean email, String action, Function<OpenOfficeDocument, T> converter) {
        Object result;
        if (!this.canConvert(document, mimeType)) {
            throw new OpenOfficeException(ReportMessages.unsupportedConversion(document.getName(), document.getMimeType(), mimeType));
        }
        ConvertTask<T> task = new ConvertTask<T>(document, email, converter, action, mimeType);
        try {
            result = task.run(this.officeService);
        }
        catch (OpenVPMSException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new OpenOfficeDocumentException(ReportMessages.conversionFailed(document.getName(), mimeType), exception);
        }
        return result;
    }

    private class ConvertTask<T>
    extends OpenOfficeTask<T> {
        private final Document document;
        private final boolean email;
        private final Function<OpenOfficeDocument, T> converter;
        private final String action;
        private final String mimeType;

        public ConvertTask(Document document, boolean email, Function<OpenOfficeDocument, T> converter, String action, String mimeType) {
            super(log.isDebugEnabled());
            this.document = document;
            this.email = email;
            this.converter = converter;
            this.action = action;
            this.mimeType = mimeType;
        }

        @Override
        protected T run(LocalOfficeContext context) {
            try (OpenOfficeDocument doc = this.createDocument(this.document, context);){
                if (doc.hasUserField("IsEmail")) {
                    doc.setUserField("IsEmail", Boolean.toString(this.email));
                }
                T t = this.converter.apply(doc);
                return t;
            }
        }

        @Override
        protected void start() {
            log.debug("Running {}, document='{}', id={}, mimeType={}, to={}", new Object[]{this.action, this.document.getName(), this.document.getId(), this.document.getMimeType(), this.mimeType});
        }

        @Override
        protected void stop(Exception exception, long delay, long elapsed) {
            if (exception != null) {
                log.debug("Failed to {}, document='{}', id={}, delay={}, elapsed={}: {}", new Object[]{this.action, this.document.getName(), this.document.getId(), this.duration(delay), this.duration(elapsed), exception.getMessage(), exception});
            } else {
                log.debug("Completed {}, document='{}', id={}, delay={}, elapsed={}", new Object[]{this.action, this.document.getName(), this.document.getId(), this.duration(delay), this.duration(elapsed)});
            }
        }

        private OpenOfficeDocument createDocument(Document document, LocalOfficeContext context) {
            OpenOfficeDocument doc = new OpenOfficeDocument(document, context, OpenOfficeDocumentConverter.this.handlers);
            doc.refresh();
            return doc;
        }
    }
}

